/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.xml.Child;
import electric.xml.NamespaceException;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import java.io.IOException;
import org.w3c.dom.ProcessingInstruction;

public class Instruction
extends Child
implements ProcessingInstruction {
    protected String target;
    protected String content;

    public Instruction(String target, String content) {
        this.target = target;
        this.content = content;
    }

    public Instruction(Instruction instruction) {
        this.target = instruction.target;
        this.content = instruction.content;
    }

    protected Instruction() {
    }

    public Instruction(Parent parent) {
        super(parent);
    }

    public Object clone() {
        return new Instruction(this);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void read(NodeReader reader) throws IOException, NamespaceException {
        reader.skip("<?".length());
        this.target = reader.readToken();
        this.content = reader.readToPattern("?>", 3);
    }

    public void write(NodeWriter writer) throws IOException {
        writer.writeIndent();
        writer.write("<?");
        writer.write(this.target);
        writer.write(' ');
        writer.write(this.getContent());
        writer.write("?>");
    }

    public short getNodeType() {
        return 7;
    }

    public String getNodeName() {
        return this.getTarget();
    }

    public String getNodeValue() {
        return this.getContent();
    }

    public void setNodeValue(String nodeValue) {
        this.setContent(nodeValue);
    }

    public String getData() {
        return this.getContent();
    }

    public void setData(String data) {
        this.setContent(data);
    }
}

