/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.store.filesource;

import electric.util.file.FileUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.xdb.Data;
import electric.xdb.IXDBConstants;
import electric.xdb.store.ISource;
import electric.xdb.store.IStore;
import electric.xml.Document;
import electric.xml.Element;
import java.io.File;

public class FileSource
implements ISource,
IXDBConstants,
ILoggingConstants {
    private String root;

    public FileSource(String root, boolean delete) {
        this.root = root;
        File directory = new File(root);
        if (delete && directory.exists()) {
            FileUtil.delete(directory);
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public void loadData(IStore store) {
        File directory = new File(this.root);
        File[] dataFiles = FileUtil.listFiles(directory);
        int i = 0;
        while (i < dataFiles.length) {
            block3: {
                try {
                    Document document = new Document(dataFiles[i]);
                    Element dataRoot = document.getRoot();
                    int tag = dataRoot.getInt("tag");
                    Element envelope = dataRoot.getElement("Envelope");
                    Data data = new Data(envelope);
                    store.addDataWithTag(data, tag);
                }
                catch (Exception exception) {
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception loading data", exception);
                }
            }
            ++i;
        }
    }

    public void addedData(Data data, int tag) {
        block2: {
            try {
                File file = this.getFile(data);
                Document document = new Document();
                Element dataElement = document.setRoot("data");
                dataElement.setInt("tag", tag);
                dataElement.addElement(new Element(data.getEnvelope()));
                document.write(file);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception adding data " + data, exception);
            }
        }
    }

    public void removedData(Data data, int tag) {
        block2: {
            try {
                this.getFile(data).delete();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception removing data " + data, exception);
            }
        }
    }

    private File getFile(Data data) {
        String filename = Strings.toFilename(data.getId().asString());
        return new File(this.root + File.separator + filename + ".xml");
    }
}

