/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.server;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceInfo;
import electric.fabric.util.ReferenceCache;
import electric.glue.context.ServiceContext;
import electric.registry.Registry;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.thread.ThreadPool;
import electric.wsdl.util.SignatureGenerator;
import electric.xdb.Action;
import electric.xdb.Data;
import electric.xdb.GroupInfo;
import electric.xdb.IActiveData;
import electric.xdb.IXDBConstants;
import electric.xdb.Id;
import electric.xdb.Query;
import electric.xdb.Result;
import electric.xdb.ServerInfo;
import electric.xdb.server.ActivateAction;
import electric.xdb.server.ClientDelta;
import electric.xdb.server.DeactivateAction;
import electric.xdb.server.IXDBServer;
import electric.xdb.server.JoinInfo;
import electric.xdb.server.JoinServers;
import electric.xdb.server.LocalXDBServers;
import electric.xdb.server.Member;
import electric.xdb.server.NonSystemSelector;
import electric.xdb.server.SyncInfo;
import electric.xdb.server.SyncSelector;
import electric.xdb.server.SyncWithServers;
import electric.xdb.store.Delta;
import electric.xdb.store.IDataSelector;
import electric.xdb.store.IStore;
import electric.xdb.store.IStoreListener;
import electric.xdb.store.factory.IStoreFactory;
import electric.xdb.store.selectors.AndSelector;
import electric.xdb.store.selectors.EnvelopeSelector;
import java.util.Vector;

public class XDBServer
implements IXDBServer,
Runnable,
IStoreListener,
IXDBConstants,
IFabricConstants,
ILoggingConstants {
    private static final IDataSelector SYNC_SELECTOR = new SyncSelector();
    private static final IDataSelector NON_SYSTEM_SELECTOR = new NonSystemSelector();
    private static IStoreFactory defaultStoreFactory;
    private static long syncCycle;
    private static String signature;
    private static int defaultReplicationFactor;
    private IStore store;
    private GroupInfo groupInfo;
    private ServerInfo serverInfo;
    private boolean running;
    private Context context = new Context();
    static /* synthetic */ Class class$electric$xdb$server$IXDBServer;

    public XDBServer(String name, String group, int replicationFactor) {
        this(name, group, replicationFactor, defaultStoreFactory.newStore(name, group));
    }

    public XDBServer(String name, String group, int replicationFactor, IStore store) {
        this.store = store;
        this.serverInfo = new ServerInfo();
        this.serverInfo.setName(name);
        this.groupInfo = new GroupInfo(group, replicationFactor);
        this.serverInfo.setDataCount(this.getDataCount());
        this.serverInfo.setLastTag(store.getLastTag());
        this.serverInfo.setHistory(store.getHistory());
        store.addListener(this);
        this.serverInfo.setURL(this.publishAsWebService());
        this.addData(new Data("GroupInfo", (Object)this.groupInfo));
        this.addServerInfoIfModified();
        store.perform(new ActivateAction(this, 2));
    }

    public XDBServer(IStore store) {
        this.store = store;
        this.groupInfo = (GroupInfo)store.getDataForKey("GroupInfo").getObject();
        this.serverInfo = (ServerInfo)store.getDataForKey("ServerInfo").getObject();
        this.serverInfo.setURL(this.publishAsWebService());
        this.serverInfo.setLeader(false);
        store.addListener(this);
        store.perform(new ActivateAction(this, 2));
    }

    public String toString() {
        return "XDBServer( name=" + this.getName() + ", group=" + this.getGroup() + ", size=" + this.getDataCount() + ", members=" + (this.getMembers().length + 1) + ", context=" + this.context + " )";
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public static void setSyncCycle(long syncCycle) {
        XDBServer.syncCycle = syncCycle;
    }

    public static long getSyncCycle() {
        return syncCycle;
    }

    public static void setDefaultStoreFactory(IStoreFactory defaultStoreFactory) {
        XDBServer.defaultStoreFactory = defaultStoreFactory;
    }

    public static IStoreFactory getDefaultStoreFactory() {
        return defaultStoreFactory;
    }

    public IStore getStore() {
        return this.store;
    }

    public String getPath() {
        return "/xdb/" + this.getGroup();
    }

    public String getName() {
        return this.serverInfo.getName();
    }

    public String getURL() {
        return this.serverInfo.getURL();
    }

    public String getGroup() {
        return this.groupInfo.getName();
    }

    public GroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    private void setGroupInfo(GroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    private void addServerInfoIfModified() {
        if (this.serverInfo.isModified()) {
            Data selfData = new Data(new Id("ServerInfo"), this.serverInfo, false, 0L, false);
            this.addData(selfData);
            this.serverInfo.resetModified();
        }
    }

    public boolean hasMembers() {
        return this.serverInfo.hasMembers();
    }

    public boolean hasOnlineMembers() {
        return this.serverInfo.hasOnlineMembers();
    }

    public Member[] getMembers() {
        return this.serverInfo.getMembers();
    }

    public boolean isMember(String url) {
        if (this.getURL().equals(url)) {
            return true;
        }
        return this.getMemberWithURL(url) != null;
    }

    public Member getMemberWithURL(String url) {
        return this.serverInfo.getMemberWithURL(url);
    }

    public Member getMemberWithName(String name) {
        return this.serverInfo.getMemberWithName(name);
    }

    public Member addMember(JoinInfo info) {
        return this.serverInfo.addMember(info.getName(), info.getURL());
    }

    public void addData(Data data) {
        this.addDataArray(new Data[]{data});
    }

    public void addDataArray(Data[] data) {
        int i = 0;
        while (i < data.length) {
            this.checkForGroupInfo(data[i]);
            ++i;
        }
        this.store.addDataArray(data);
    }

    private void checkForGroupInfo(Data data) {
        if (data.getKey().equals("GroupInfo")) {
            this.setGroupInfo((GroupInfo)data.getObject());
        }
    }

    public void removeDataForKey(String key) {
        this.removeDataForKeys(new String[]{key});
    }

    public void removeDataForKeys(String[] keys) {
        Data[] data = new Data[keys.length];
        int i = 0;
        while (i < keys.length) {
            data[i] = Data.getRemoveDataWithKeyData(keys[i]);
            ++i;
        }
        this.addDataArray(data);
    }

    public void removeDataForQuery(Query query) {
        this.removeDataForSelector(this.getSelectorForQuery(query));
    }

    public void removeDataForSelector(IDataSelector selector) {
        Id[] ids = this.store.getIdsForSelector(selector);
        Data[] data = new Data[ids.length];
        int i = 0;
        while (i < ids.length) {
            data[i] = Data.getRemoveDataWithKeyData(ids[i].getKey());
            ++i;
        }
        this.addDataArray(data);
    }

    public void removeAllData() {
        this.removeDataForQuery(Query.getAllData());
    }

    public String[] getKeysForSelector(IDataSelector selector) {
        return this.store.getKeysForSelector(selector);
    }

    public String[] getAllKeys() {
        return this.getKeysForSelector(NON_SYSTEM_SELECTOR);
    }

    public int getDataCountForSelector(IDataSelector selector) {
        return this.store.getDataCountForSelector(selector);
    }

    public int getDataCountForQuery(Query query) {
        return this.getDataCountForSelector(this.getSelectorForQuery(query));
    }

    public int getDataCount() {
        return this.getDataCountForSelector(NON_SYSTEM_SELECTOR);
    }

    public Data[] getAllData() {
        return this.getDataForQuery(Query.getAllData());
    }

    public Data[] getDataForIds(Id[] ids) {
        return this.store.getDataForIds(ids);
    }

    public Data[] getDataForQuery(Query query) {
        return this.store.getDataForSelector(this.getSelectorForQuery(query));
    }

    public Data getDataForKey(String key) {
        return this.store.getDataForKey(key);
    }

    public Data[] getDataForKeys(String[] keys) {
        return this.store.getDataForKeys(keys);
    }

    public void dieUpdate(String[] keys, long dieAt) {
        this.store.dieUpdate(keys, dieAt);
    }

    public Result perform(Action action) {
        return action.perform(this);
    }

    public SyncInfo getSyncInfo(int startTag) {
        Delta delta = this.store.getDelta(startTag, SYNC_SELECTOR);
        return new SyncInfo(delta.getIds(), delta.getLastTag(), this.serverInfo.isLeader());
    }

    public Id[] getMissingIds(Id[] ids) {
        return this.store.getMissingIds(ids);
    }

    private void syncWithGroup() {
        if (this.hasOnlineMembers()) {
            new SyncWithServers(this).start();
        }
    }

    public static void setDefaultReplicationFactor(int size) {
        defaultReplicationFactor = size;
    }

    public static int getDefaultReplicationFactor() {
        return defaultReplicationFactor;
    }

    public int getGroupSize() {
        return this.serverInfo.getGroupSize();
    }

    public int getReplicationFactor() {
        return this.groupInfo.getReplicationFactor();
    }

    public void setPreferredGroupSize(int size) {
        this.groupInfo.setReplicationFactor(size);
        this.addData(new Data("GroupInfo", (Object)this.groupInfo));
    }

    private void checkGroupSize() {
        int replicationFactor = this.getReplicationFactor();
        if (replicationFactor == 0 || !this.isLeader()) {
            return;
        }
        int groupSize = this.getGroupSize();
        if (groupSize < replicationFactor) {
            this.expandGroup();
        } else if (groupSize > replicationFactor) {
            this.contractGroup();
        }
    }

    private void expandGroup() {
        Member[] members = this.serverInfo.getMembers();
        Vector<String> existingURLs = new Vector<String>();
        existingURLs.addElement(this.getURL());
        int i = 0;
        while (i < members.length) {
            if (members[i].isOnline()) {
                existingURLs.addElement(members[i].getURL());
            }
            ++i;
        }
        Object[] existingURLsArray = new String[existingURLs.size()];
        existingURLs.copyInto(existingURLsArray);
        this.createServer((String[])existingURLsArray);
    }

    private void contractGroup() {
        this.stop();
    }

    private void createServer(String[] existingURLs) {
        block4: {
            try {
                String url;
                StringBuffer buffer = new StringBuffer();
                buffer.append("?glue");
                buffer.append("&service.signature=" + signature);
                buffer.append("&service.group=" + this.getGroup());
                buffer.append("&service.replicationFactor=" + this.getReplicationFactor());
                int i = 0;
                while (i < existingURLs.length) {
                    XURL endpoint = new XURL(existingURLs[i]).getHostAndPortXURL();
                    buffer.append("&avoidHost=" + endpoint);
                    buffer.append("&server=" + existingURLs[i]);
                    ++i;
                }
                String path = buffer.toString();
                ServiceInfo serviceInfo = Fabric.getServiceManager().createService(path);
                String string = url = serviceInfo != null ? serviceInfo.getWSDLURL() : null;
                if (Log.isLogging(IXDBConstants.XDB_SERVER_EVENT)) {
                    Log.log(IXDBConstants.XDB_SERVER_EVENT, (Object)("created xdb server for group " + this.getGroup() + " at " + url));
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(IXDBConstants.XDB_SERVER_EVENT)) break block4;
                Log.log(IXDBConstants.XDB_SERVER_EVENT, "could not create xdb server for group " + this.getGroup(), exception);
            }
        }
    }

    private void checkLeadership() {
        this.isLeader();
    }

    private synchronized boolean isLeader() {
        if (!this.serverInfo.isGroupChanged()) {
            return this.serverInfo.isLeader();
        }
        boolean oldIsGroupLeader = this.serverInfo.isLeader();
        this.serverInfo.resetGroupChanged();
        boolean isGroupLeader = true;
        String name = this.getName();
        Member[] members = this.serverInfo.getMembers();
        int i = 0;
        while (i < members.length) {
            Member member = members[i];
            if (member.isOnline() && name.compareTo(member.getName()) <= 0) {
                isGroupLeader = false;
                break;
            }
            ++i;
        }
        this.serverInfo.setLeader(isGroupLeader);
        if (isGroupLeader && !oldIsGroupLeader) {
            this.store.perform(new ActivateAction(this, 1));
        } else if (oldIsGroupLeader && !isGroupLeader) {
            this.store.perform(new DeactivateAction(this, 1));
        }
        return isGroupLeader;
    }

    public void joinServerIfNew(String url) {
        if (this.getURL().equals(url)) {
            return;
        }
        Member member = this.getMemberWithURL(url);
        if (member == null || !member.isOnline()) {
            this.joinServers(new String[]{url});
        }
    }

    public void joinServers(String[] urls) {
        if (urls.length > 0) {
            new JoinServers(this, urls).start();
        }
    }

    public JoinInfo join(JoinInfo joinInfo) {
        if (Log.isLogging(IXDBConstants.XDB_SERVER_EVENT)) {
            Log.log(IXDBConstants.XDB_SERVER_EVENT, (Object)(this + " joined by " + joinInfo));
        }
        Member member = this.serverInfo.addMember(joinInfo.getName(), joinInfo.getURL());
        member.setOnline();
        return new JoinInfo(this.getName(), this.getURL());
    }

    private void joinAllInGroup() {
        Object[] serverURLs = this.findServersInGroup();
        int index = ArrayUtil.indexOf(this.getURL(), serverURLs);
        if (index != -1) {
            serverURLs = (String[])ArrayUtil.removeElementAt(serverURLs, index);
        }
        this.joinServers((String[])serverURLs);
    }

    private String[] findServersInGroup() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("?glue");
        buffer.append("&service.signature=" + signature);
        buffer.append("&service.group=" + this.getGroup());
        String path = buffer.toString();
        try {
            ServiceInfo[] matches = Fabric.getServiceManager().findServicesForPath(path);
            String[] urls = new String[matches.length];
            int i = 0;
            while (i < matches.length) {
                urls[i] = matches[i].getWSDLURL();
                ++i;
            }
            return urls;
        }
        catch (Exception exception) {
            if (Log.isLogging(IXDBConstants.XDB_SERVER_EVENT)) {
                Log.log(IXDBConstants.XDB_SERVER_EVENT, "found no xdb servers for group " + this.getGroup(), exception);
            }
            return new String[0];
        }
    }

    public synchronized boolean isServerWithURLInGroup(String url) {
        return this.getURL().equals(url) ? true : this.getMemberWithURL(url) != null;
    }

    public ClientDelta getDataForClient(Query query, Id[] ids) {
        Data[] data = this.store.getDataForSelector(this.getSelectorForQuery(query));
        Vector<Data> dataVector = new Vector<Data>();
        int i = 0;
        while (i < data.length) {
            Id id = data[i].getId();
            boolean add = true;
            int j = 0;
            while (j < ids.length) {
                if (id.getKey().equals(ids[j].getKey())) {
                    if (id.getTimestamp() > ids[j].getTimestamp()) break;
                    add = false;
                    break;
                }
                ++j;
            }
            if (add) {
                dataVector.addElement(data[i]);
            }
            ++i;
        }
        Vector<String> keyVector = new Vector<String>();
        int i2 = 0;
        while (i2 < ids.length) {
            Id id = ids[i2];
            boolean flush = true;
            int j = 0;
            while (j < data.length) {
                if (id.getKey().equals(data[j].getKey())) {
                    flush = false;
                    break;
                }
                ++j;
            }
            if (flush) {
                keyVector.addElement(id.getKey());
            }
            ++i2;
        }
        if (dataVector.isEmpty() && keyVector.isEmpty()) {
            return null;
        }
        Object[] dataArray = null;
        if (!dataVector.isEmpty()) {
            dataArray = new Data[dataVector.size()];
            dataVector.copyInto(dataArray);
        }
        Object[] keyArray = null;
        if (!keyVector.isEmpty()) {
            keyArray = new String[keyVector.size()];
            keyVector.copyInto(keyArray);
        }
        return new ClientDelta((Data[])dataArray, (String[])keyArray);
    }

    private IDataSelector getSelectorForQuery(Query query) {
        return new AndSelector(new EnvelopeSelector(query.getEnvelope()), NON_SYSTEM_SELECTOR);
    }

    public void ping() {
    }

    public void addedData(Data data, int tag) {
        block3: {
            if (!data.isRemoved() && (data.getActive() == 1 && this.isLeader() || data.getActive() == 2) && !data.isActivated()) {
                data.setActivated(true);
                try {
                    ((IActiveData)data.getObject()).activate(this);
                }
                catch (Exception exception) {
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during activation of " + data, exception);
                }
            }
        }
        this.serverInfo.setDataCount(this.getDataCount());
        this.serverInfo.setLastTag(this.store.getLastTag());
    }

    public void removedData(Data data, int tag) {
        if (data.isActivated()) {
            block3: {
                try {
                    ((IActiveData)data.getObject()).deactivate(this);
                }
                catch (Exception exception) {
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during deactivation of " + data, exception);
                }
            }
            data.setActivated(false);
        }
        this.serverInfo.setDataCount(this.getDataCount());
        this.serverInfo.setLastTag(this.store.getLastTag());
    }

    public void start() {
        block2: {
            try {
                this.syncWithGroup();
                LocalXDBServers.addedServer(this);
                this.publishToFabric();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during XDB server start", exception);
            }
        }
        ThreadPool.getShared().run(this);
    }

    public void restart() {
        this.joinAllInGroup();
        this.start();
    }

    public void stop() {
        block2: {
            try {
                this.running = false;
                this.store.perform(new DeactivateAction(this, 2));
                this.unpublishAsWebService();
                this.unpublishFromFabric();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during XDB server stop", exception);
            }
        }
    }

    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Thread.sleep(syncCycle);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cycle();
        }
    }

    private void cycle() {
        block2: {
            try {
                this.checkLeadership();
                this.syncWithGroup();
                this.checkGroupSize();
                this.addServerInfoIfModified();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during XDB server cycle", exception);
            }
        }
    }

    private String publishAsWebService() {
        try {
            ServiceContext context = new ServiceContext();
            context.setDescription("fabric " + this.getGroup() + " xdb server");
            context.setDocumentStyle();
            Registry.publish(this.getPath(), (Object)this, class$electric$xdb$server$IXDBServer == null ? (class$electric$xdb$server$IXDBServer = XDBServer.class$("electric.xdb.server.IXDBServer")) : class$electric$xdb$server$IXDBServer, (Context)context);
            return Registry.getPath(this) + ".wsdl";
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during publish XDB server as web service", exception);
            }
            return null;
        }
    }

    private void unpublishAsWebService() {
        block2: {
            try {
                Registry.unpublish(this.getPath());
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during unpublish XDB server as web service", exception);
            }
        }
    }

    private void publishToFabric() {
        block2: {
            try {
                ServerInfo serverInfo = this.getServerInfo();
                ServiceInfo serviceInfo = new ServiceInfo(this.getURL());
                serviceInfo.addMetadata("name", serverInfo.getName());
                serviceInfo.addMetadata("group", this.getGroup());
                serviceInfo.addMetadata("inFabricServer", "true");
                serviceInfo.addMetadata("systemService", "true");
                serviceInfo.setDescription("fabric " + this.getGroup() + " xdb server");
                Fabric.getServiceManager().publishUsingInfo(serviceInfo);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during publish XDB server to fabric", exception);
            }
        }
    }

    private void unpublishFromFabric() {
        block2: {
            try {
                String wsdlURL = this.getServerInfo().getURL();
                String endpoint = wsdlURL.substring(0, wsdlURL.length() - 5);
                Fabric.getServiceManager().unpublishUsingEndpoint(endpoint);
                ReferenceCache.flush(wsdlURL);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during unpublish XDB server from fabric", exception);
            }
        }
    }

    public void livenessPing() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        syncCycle = 5000L;
        signature = SignatureGenerator.getDocLitSignature(class$electric$xdb$server$IXDBServer == null ? (class$electric$xdb$server$IXDBServer = XDBServer.class$("electric.xdb.server.IXDBServer")) : class$electric$xdb$server$IXDBServer);
        defaultReplicationFactor = 2;
    }
}

