/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.util.array.ArrayUtil;
import electric.util.named.IQNamed;
import electric.wsdl.Binding;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Operations;
import electric.wsdl.Port;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.wsdl.WSDLFactories;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.schema.SchemaException;
import java.util.Hashtable;

public final class Service
implements IQNamed,
IWSDLConstants {
    private WSDL wsdl;
    private String targetNamespace;
    private String name;
    private String documentation;
    private Port[] ports = new Port[0];
    private Hashtable portClassToOperations = new Hashtable();

    public Service(WSDL wsdl, String targetNamespace, Element service) throws WSDLException, SchemaException {
        this.wsdl = wsdl;
        this.targetNamespace = targetNamespace;
        this.name = service.getAttributeValue("name");
        if (this.name == null) {
            throw new WSDLException("<service> is missing name attribute");
        }
        this.documentation = service.getTextString("documentation");
        Elements ports = service.getElements("port");
        while (ports.hasMoreElements()) {
            this.addPort(WSDLFactories.newPort(this, ports.next()));
        }
    }

    public Service(WSDL wsdl, String namespace, String documentation) {
        this.wsdl = wsdl;
        this.targetNamespace = namespace;
        this.name = wsdl.getName();
        this.documentation = documentation;
    }

    public String toString() {
        return "Service( " + this.targetNamespace + ":" + this.name + " )";
    }

    public WSDL getWSDL() {
        return this.wsdl;
    }

    public String getNamespace() {
        return this.targetNamespace;
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void addPort(Port port) {
        this.ports = (Port[])ArrayUtil.addElement(this.ports, port);
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public Port[] getPorts(Class type) {
        Port[] selected = new Port[]{};
        int i = 0;
        while (i < this.ports.length) {
            if (type.isInstance(this.ports[i])) {
                selected = (Port[])ArrayUtil.addElement(selected, this.ports[i]);
            }
            ++i;
        }
        return selected;
    }

    public synchronized Operations getOperations(Class portClass) {
        Operations operations = (Operations)this.portClassToOperations.get(portClass);
        if (operations != null) {
            return operations;
        }
        operations = new Operations(this.wsdl);
        Binding[] bindings = this.getBindings(portClass);
        int i = 0;
        while (i < bindings.length) {
            operations.addOperations(bindings[i].getOperations());
            ++i;
        }
        this.portClassToOperations.put(portClass, operations);
        return operations;
    }

    public Binding[] getBindings(Class portClass) {
        Object[] bindings = new Binding[]{};
        int i = 0;
        while (i < this.ports.length) {
            Port port = this.ports[i];
            if (portClass.isAssignableFrom(port.getClass()) && ArrayUtil.indexOfIdentity(port.getBinding(), bindings) == -1) {
                bindings = (Binding[])ArrayUtil.addElement(bindings, port.getBinding());
            }
            ++i;
        }
        return bindings;
    }

    public void writeWSDL(Element definitions) {
        String wsdlPrefix = definitions.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element service = definitions.addElement(wsdlPrefix, "service");
        service.setAttribute("name", this.name);
        if (this.documentation != null) {
            service.setString(wsdlPrefix, "documentation", this.documentation);
        }
        int i = 0;
        while (i < this.ports.length) {
            this.ports[i].writeWSDL(service);
            ++i;
        }
    }
}

