/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.wsdl.IWSDLConstants;
import electric.wsdl.Message;
import electric.wsdl.Operation;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.io.schema.SchemaException;
import java.util.Vector;

public class MessageDecl
implements IWSDLConstants {
    private static final Message VOID = new Message();
    private String type;
    private String name;
    private Message message;

    public MessageDecl(Operation operation, Element messageReference, String type) throws WSDLException, SchemaException {
        this.type = type;
        if (messageReference == null) {
            this.message = VOID;
            return;
        }
        this.name = messageReference.getAttributeValue("name");
        String messageName = messageReference.getAttributeValue("message");
        if (messageName == null) {
            throw new WSDLException("<" + type + "> is missing message attribute for operation " + this.name);
        }
        this.message = operation.getWSDL().getMessage(messageReference.getParentElement().getQName(messageName));
    }

    public MessageDecl(Message message, String name, String type) {
        this.type = type;
        this.message = message;
        this.name = name;
    }

    public void addDependencies(Vector dependencies) {
        this.message.addDependencies(dependencies);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void writeWSDL(Element operation) {
        if (this.message != VOID) {
            String wsdlPrefix = operation.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
            Element element = operation.addElement(wsdlPrefix, this.type);
            element.setAttribute("name", this.name);
            element.setAttribute("message", "tns:" + this.message.getName());
        }
    }

    public boolean isVoid() {
        return this.message == VOID;
    }

    public static MessageDecl getVoid() {
        return new MessageDecl(VOID, "void", "output");
    }
}

