/*
 * Decompiled with CFR 0.152.
 */
package electric.util.reflect;

import electric.util.classloader.ClassLoaders;
import electric.util.reflect.MethodLookup;
import electric.util.reflect.Reflect;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class Creator {
    public static Object newInstance(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ClassLoaders.loadClass(classname).newInstance();
    }

    public static Object newInstance(String classname, ClassLoader loader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ClassLoaders.loadClass(classname, loader).newInstance();
    }

    public static Object newInstance(Class type, String[] methodArgs) throws Throwable {
        Constructor constructor = MethodLookup.getConstructor(type, methodArgs.length);
        Object[] args = new Object[methodArgs.length];
        int i = 0;
        while (i < args.length) {
            args[i] = Reflect.valueOf(methodArgs[i], constructor.getParameterTypes()[i]);
            ++i;
        }
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException exception) {
            throw exception.getTargetException();
        }
    }

    public static Object newInstance(Class type, Class[] argTypes, String[] methodArgs) throws Throwable {
        Constructor constructor = MethodLookup.getConstructor(type, argTypes);
        Object[] args = new Object[methodArgs.length];
        int i = 0;
        while (i < args.length) {
            args[i] = Reflect.valueOf(methodArgs[i], constructor.getParameterTypes()[i]);
            ++i;
        }
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException exception) {
            throw exception.getTargetException();
        }
    }

    public static Object newInstance(Element descriptor, ClassLoader loader) throws Throwable {
        Element element = descriptor.getElement("constructor");
        Class classObj = null;
        String methodName = null;
        boolean isFactory = false;
        if (element == null) {
            element = descriptor.getElement("factory");
            if (element == null) {
                throw new ParseException("cannot create object. either <constructor> or <factory> is required in descriptor element");
            }
            methodName = element.getString("method");
            if (methodName == null) {
                throw new ParseException("method name is missing from factory element in service descriptor: " + element);
            }
            isFactory = true;
        }
        String className = element.getString("class");
        try {
            classObj = ClassLoaders.loadClass(className, loader);
        }
        catch (ClassNotFoundException exception) {
            String classType = isFactory ? "factory" : "service";
            throw new ClassNotFoundException("unable to find " + classType + " class - " + className);
        }
        String[] args = Creator.getArgs(element);
        if (isFactory) {
            return Reflect.invoke(classObj, methodName, args);
        }
        return Creator.newInstance(classObj, args);
    }

    private static String[] getArgs(Element element) {
        Element argElement = element.getElement("args");
        String[] args = new String[]{};
        if (argElement == null) {
            return args;
        }
        Elements elements = argElement.getElements();
        args = new String[elements.size()];
        int i = 0;
        while (elements.hasMoreElements()) {
            args[i] = elements.next().getString();
            ++i;
        }
        return args;
    }
}

