/*
 * Decompiled with CFR 0.152.
 */
package electric.util.product;

import electric.util.license.ILicenseConstants;
import electric.util.license.LicenseInfo;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.util.Hashtable;

public final class ProductInfo
implements ILoggingConstants,
ILicenseConstants {
    private String name;
    private int id;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private LicenseInfo licenseInfo;
    private Hashtable properties;

    public ProductInfo() {
    }

    public ProductInfo(String name, int id, int majorVersion, int minorVersion, int patchVersion) {
        this.name = name;
        this.id = id;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public String getVersion() {
        return this.majorVersion + "." + this.minorVersion + (this.patchVersion > 0 ? "." + this.patchVersion : "");
    }

    public void setLicenseInfo(LicenseInfo licenseInfo) {
        this.licenseInfo = licenseInfo;
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getShortDescription());
        buffer.append(' ').append("(c) 2001-2003 webMethods, Inc.");
        String licenseLimitationsDesc = this.getLicenseLimitationsDescription();
        if (licenseLimitationsDesc.length() > 0) {
            buffer.append("\n").append(licenseLimitationsDesc);
        }
        return buffer.toString();
    }

    public String getShortDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name).append(' ');
        buffer.append(this.majorVersion).append('.').append(this.minorVersion);
        if (this.patchVersion > 0) {
            buffer.append('.').append(this.patchVersion);
        }
        buffer.append(" Beta2");
        return buffer.toString();
    }

    public boolean verify(ProductInfo productInfo) {
        boolean matches;
        String name = productInfo.getName();
        int majorVersion = productInfo.getMajorVersion();
        int minorVersion = productInfo.getMinorVersion();
        int patchVersion = productInfo.getPatchVersion();
        boolean bl = matches = !(name != null && (name == null || !name.equalsIgnoreCase(this.getName())) || majorVersion != -1 && majorVersion != this.getMajorVersion() || minorVersion != -1 && minorVersion != this.getMinorVersion() || patchVersion != -1 && patchVersion != this.getPatchVersion());
        if (!matches && Log.isLogging(ILoggingConstants.COMMENT_EVENT)) {
            Log.log(ILoggingConstants.COMMENT_EVENT, (Object)"product information from the configuration file doesn't match");
            Log.log(ILoggingConstants.COMMENT_EVENT, (Object)"make sure to upgrade config.xml to the version of the file from the distribution");
        }
        return matches;
    }

    public String getLicenseLimitationsDescription() {
        LicenseInfo licenseInfo = this.getLicenseInfo();
        if (licenseInfo == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        String expDate = (String)licenseInfo.getProperty("expirationDate");
        Integer connLimit = (Integer)licenseInfo.getProperty("connectionLimit");
        if (expDate != null) {
            buffer.append("evaluation expires on ");
            buffer.append(expDate);
            if (connLimit != -1) {
                buffer.append("\n");
            }
        }
        if (connLimit != -1) {
            buffer.append("product is limited to ");
            buffer.append(connLimit);
            buffer.append(" concurrent connections");
        }
        return buffer.toString();
    }
}

