/*
 * Decompiled with CFR 0.152.
 */
package electric.util.mime;

import electric.glue.IGLUELoggingConstants;
import electric.util.Context;
import electric.util.UUID;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.http.IHTTPConstants;
import electric.util.ids.IIDGenerator;
import electric.util.io.ChunkedInputStream;
import electric.util.io.Streams;
import electric.util.log.Log;
import electric.util.mime.FileDataHandler;
import electric.util.mime.IDataHandler;
import electric.util.mime.IMIMEConstants;
import electric.util.mime.MIMEHeaders;
import electric.util.string.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.net.URLConnection;

public class MIMEData
implements IIDGenerator,
IMIMEConstants,
IHTTPConstants {
    public MIMEHeaders headers = new MIMEHeaders();
    public InputStream input;
    private String baseContentLocation;
    private String contentLabel;
    private String contentId;
    private IDataHandler handler;
    private byte[] headersBytes;
    private byte[] delimiter;

    public MIMEData() {
    }

    public MIMEData(String content) {
        this(content, "text/plain");
    }

    public MIMEData(String content, String contentType) {
        this(content.getBytes(), contentType);
    }

    public MIMEData(byte[] bytes) {
        this(bytes, "application/binary");
    }

    public MIMEData(byte[] bytes, String contentType) {
        this((InputStream)new ByteArrayInputStream(bytes), bytes.length, contentType);
    }

    public MIMEData(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.connect();
        this.generateId();
        this.setContentType(connection.getContentType());
        this.setInputStream(connection.getInputStream());
        this.setContentLength(connection.getContentLength());
    }

    public MIMEData(InputStream input, int contentLength) {
        this(input, contentLength, "application/binary");
    }

    public MIMEData(InputStream input, int contentLength, String contentType) {
        this.setInputStream(input);
        this.setContentLength(contentLength);
        this.setContentType(contentType);
    }

    public MIMEData(File file) throws FileNotFoundException {
        this(file, "application/binary");
    }

    public MIMEData(File file, String contentType) throws FileNotFoundException {
        this.generateId();
        this.setInputStream(new FileInputStream(file));
        this.setContentLength((int)file.length());
        this.setContentType(contentType);
    }

    public MIMEData(InputStream input, String contentLocation, Context context) throws IOException {
        this.setBaseContentLocation(contentLocation);
        this.readHeaders(input);
        this.readContent(input, context);
    }

    public MIMEData(InputStream input, String contentLocation, String seperator, Context context) throws IOException {
        this.setBaseContentLocation(contentLocation);
        this.setDelimiter(seperator.getBytes());
        this.readHeaders(input);
        this.readContent(input, context);
    }

    public void setInputStream(InputStream input) {
        this.input = input;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public void setContentType(String type) {
        this.headers.setHeader("Content-Type", type);
    }

    public String getContentType() {
        return this.headers.getHeader("Content-Type");
    }

    public int getContentLength() {
        return this.headers.getIntHeader("Content-Length");
    }

    public void setContentLength(int contentLength) {
        this.headers.setIntHeader("Content-Length", contentLength);
    }

    public InputStream getFormattedInputStream() throws IOException {
        byte[] partBytes = (byte[])ArrayUtil.addElements(IHTTPConstants.EOL, this.delimiter);
        partBytes = (byte[])ArrayUtil.addElements(partBytes, IHTTPConstants.EOL);
        partBytes = (byte[])ArrayUtil.addElements(partBytes, this.getHeadersBytes());
        partBytes = (byte[])ArrayUtil.addElements(partBytes, IHTTPConstants.EOL);
        SequenceInputStream stream = new SequenceInputStream(new ByteArrayInputStream(partBytes), this.input);
        return new SequenceInputStream(stream, new ByteArrayInputStream(IHTTPConstants.EOL));
    }

    public int getFormattedContentLength() throws IOException {
        if (this.delimiter == null) {
            throw new IllegalStateException("cannot call getFormattedContentLength until mime boundary is set");
        }
        int formattedContentLength = this.getContentLength();
        formattedContentLength += this.getHeadersBytes().length;
        formattedContentLength += this.delimiter.length;
        return formattedContentLength += IHTTPConstants.EOL.length * 4;
    }

    byte[] getHeadersBytes() throws IOException {
        if (this.headersBytes == null) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.headers.writeHeaders(output);
            this.headersBytes = output.toByteArray();
        }
        return this.headersBytes;
    }

    public void setBaseContentLocation(String baseContentLocation) {
        this.baseContentLocation = baseContentLocation;
    }

    public String getContentId() {
        String id = this.headers.getHeader("Content-ID");
        if (id == null) {
            return null;
        }
        if (id.startsWith("<")) {
            id = id.substring(1);
        }
        if (id.endsWith(">")) {
            id = id.substring(0, id.length() - 1);
        }
        return id;
    }

    public String getContentLabel() {
        return this.contentLabel;
    }

    public void setContentLabel(String contentLabel) {
        this.contentLabel = contentLabel;
    }

    public void setHandler(IDataHandler handler) {
        this.handler = handler;
    }

    public IDataHandler getHandler() {
        return this.handler;
    }

    public byte[] getBytes() throws IOException {
        return Streams.readFully(this.input, this.getContentLength());
    }

    public boolean dispose() throws IOException {
        return this.handler != null ? this.handler.dispose() : true;
    }

    public void readHeaders(InputStream input) throws IOException {
        this.headers.readHeaders(input);
        String location = this.headers.getHeader("Content-Location");
        if (location != null) {
            if (XURL.hasProtocol(location)) {
                this.contentLabel = location;
                return;
            }
            StringBuffer buffer = new StringBuffer();
            if (this.baseContentLocation != null) {
                if (!XURL.hasProtocol(this.baseContentLocation)) {
                    buffer.append("thismessage:/");
                }
                buffer.append(Strings.splice(this.baseContentLocation, location));
            } else {
                buffer.append("thismessage:/");
                buffer.append(location);
            }
            this.contentLabel = buffer.toString();
        } else {
            this.contentLabel = "cid:" + this.getContentId();
        }
    }

    public void readContent(InputStream inputStream, Context context) throws IOException {
        String encoding = this.headers.getHeader("Transfer-Encoding");
        if (encoding != null && encoding.toLowerCase().startsWith("chunked") && !(inputStream instanceof ChunkedInputStream)) {
            inputStream = new ChunkedInputStream(inputStream);
        }
        this.prepareDataHandler(context);
        int length = this.getContentLength();
        String label = this.getContentLabel();
        this.handler.readContent(inputStream, length, label, this.delimiter, context);
        this.input = this.handler.getInputStream();
        if (this.input == null) {
            throw new IOException("mime data handler produced invalid input stream for the mime content");
        }
        if (this.input.equals(inputStream)) {
            throw new IOException("mime data handler must create a new input stream, original input stream cannot be reused");
        }
    }

    private synchronized void prepareDataHandler(Context context) throws IOException {
        if (this.handler != null) {
            return;
        }
        Object dataHandler = context.getProperty(this.getContentType() + " dataHandler");
        if (dataHandler == null) {
            dataHandler = context.getProperty("*/* dataHandler");
        }
        if (dataHandler == null) {
            if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)"*****using FileDataHandler for MIMEData*****");
            }
            this.handler = new FileDataHandler();
        } else if (dataHandler instanceof IDataHandler) {
            this.handler = (IDataHandler)dataHandler;
        } else {
            throw new IOException("the data handler " + dataHandler + " does not implement electric.util.mime.IDataHandler");
        }
    }

    public String generateId() {
        this.contentId = this.getContentId();
        if (this.contentId == null) {
            this.contentId = "http://" + new UUID().getKey();
            this.headers.setHeader("Content-ID", "<" + this.contentId + ">");
        } else if (!XURL.hasProtocol(this.contentId)) {
            this.contentId = "thismessage:/" + this.contentId;
        }
        return "cid:" + this.contentId;
    }

    public void setDelimiter(byte[] delimiter) {
        this.delimiter = delimiter;
    }

    public byte[] getDelimiter() {
        return this.delimiter;
    }
}

