/*
 * Decompiled with CFR 0.152.
 */
package electric.util.mime;

import electric.util.Context;
import electric.util.UUID;
import electric.util.io.Streams;
import electric.util.log.Log;
import electric.util.mime.IDataHandler;
import electric.util.mime.IMIMEConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDataHandler
implements IDataHandler,
IMIMEConstants {
    public static final int BUFFER_SIZE = 16384;
    private static final long HTTP_EVENT = Log.getCode("HTTP");
    private File file;
    private FileInputStream fileInputStream;

    public File getFile() {
        return this.file;
    }

    protected int getCopyBufferSize() {
        return 16384;
    }

    public void readContent(InputStream input, int length, String id, byte[] delimeter, Context context) throws IOException {
        this.setOutputFile(context);
        FileOutputStream output = new FileOutputStream(this.file);
        if (length != -1) {
            Streams.copy(input, output, length, this.getCopyBufferSize(), -1L);
        } else {
            Streams.copy(input, (OutputStream)output, delimeter, HTTP_EVENT);
        }
        output.close();
        this.fileInputStream = new FileInputStream(this.file);
    }

    protected void setOutputFile(Context context) {
        String mimeDataDirectory = context.getStringProperty("dataDirectory");
        if (mimeDataDirectory == null) {
            mimeDataDirectory = "./mimedata";
        }
        File directory = new File(mimeDataDirectory);
        directory.mkdirs();
        String filename = new UUID().getKey() + ".mime";
        this.file = new File(directory, filename);
    }

    public InputStream getInputStream() {
        return this.fileInputStream;
    }

    public boolean dispose() throws IOException {
        this.fileInputStream.close();
        return this.file.delete();
    }
}

