/*
 * Decompiled with CFR 0.152.
 */
package electric.util.license;

import electric.util.ExceptionUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.license.License;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IProductConfig;
import electric.util.product.Product;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Enabler
implements ILoggingConstants {
    private static boolean validated = false;

    public static void enableFeature(String className, IProductConfig productConfig) {
        block10: {
            if (Product.getProductConfig() == null) {
                return;
            }
            if (!validated) {
                try {
                    License.verifyLicense(productConfig);
                    validated = true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                        Log.log(ILoggingConstants.ERROR_EVENT, (Object)("invalid or expired activation information. " + className + " is disabled"));
                    }
                    return;
                }
            }
            try {
                Class featureClass = ClassLoaders.loadClass(className);
                Method enableMethod = featureClass.getMethod("enable", new Class[0]);
                enableMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException exception) {
            }
            catch (NoClassDefFoundError error) {
            }
            catch (Throwable exception) {
                if (exception instanceof InvocationTargetException) {
                    exception = ((InvocationTargetException)exception).getTargetException();
                }
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block10;
                Log.log(ILoggingConstants.ERROR_EVENT, className + " feature cannot be enabled due to exception", exception);
            }
        }
    }

    public static boolean enable() {
        if (Product.getProductConfig() == null) {
            return false;
        }
        int enablerPos = ExceptionUtil.getStackTracePos("electric.util.license.Enabler");
        int commandPos = ExceptionUtil.getStackTracePos("electric.util.command.Command");
        if (enablerPos != -1) {
            return commandPos == -1 ? true : enablerPos < commandPos;
        }
        return false;
    }

    public static void disableFeature(String className) {
        block5: {
            try {
                Class featureClass = ClassLoaders.loadClass(className);
                Method disableMethod = featureClass.getMethod("disable", new Class[0]);
                disableMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException exception) {
            }
            catch (NoClassDefFoundError error) {
            }
            catch (Throwable exception) {
                if (exception instanceof InvocationTargetException) {
                    exception = ((InvocationTargetException)exception).getTargetException();
                }
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block5;
                Log.log(ILoggingConstants.ERROR_EVENT, className + " feature cannot be disabled due to exception", exception);
            }
        }
    }
}

