/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import java.io.IOException;
import java.io.OutputStream;

public class MonitoringOutputStream
extends OutputStream {
    private OutputStream out;
    private long totalBytesWritten;

    public MonitoringOutputStream(OutputStream out) {
        this.out = out;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.totalBytesWritten;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.totalBytesWritten += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.totalBytesWritten += (long)len;
    }

    public long getBytesWritten() {
        return this.totalBytesWritten;
    }
}

