/*
 * Decompiled with CFR 0.152.
 */
package electric.util.encoding;

import electric.util.array.ArrayUtil;
import electric.util.string.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public class XMLEncodings {
    private static final String[] DEFAULT_SUGGESTED_ENCODINGS = new String[]{"UTF8", "UTF-16BE", "UTF-16LE", "cp037"};
    private static String[] suggestedEncodings = new String[0];
    private static byte[][] suggestedEncodingBytes = new byte[0][0];
    private static final String ENCODING = "encoding";
    private static final String XML_DECL = "<?xml";
    private static final Hashtable xmlToJavaEncodings = new Hashtable();
    private static final Hashtable javaToXMLEncodings = new Hashtable();
    private static String systemEncoding;

    public static void addSuggestedEncoding(String encoding) throws UnsupportedEncodingException {
        byte[] bytes = XML_DECL.getBytes(encoding);
        suggestedEncodingBytes = (byte[][])ArrayUtil.addElement(suggestedEncodingBytes, bytes);
        suggestedEncodings = (String[])ArrayUtil.addElement(suggestedEncodings, encoding);
    }

    public static String[] getSuggestedEncodings() {
        return suggestedEncodings;
    }

    public static String getJavaEncoding(byte[] header) throws UnsupportedEncodingException {
        if (Strings.hasBOM(header)) {
            byte[] header2 = new byte[header.length - 2];
            System.arraycopy(header, 2, header2, 0, header2.length);
            header = header2;
        }
        if (suggestedEncodingBytes.length == 0) {
            XMLEncodings.initSuggestedEncodings(DEFAULT_SUGGESTED_ENCODINGS);
        }
        int i = 0;
        while (i < suggestedEncodingBytes.length) {
            String encoding;
            if (XMLEncodings.matches(header, suggestedEncodingBytes[i]) && (encoding = XMLEncodings.getJavaEncoding(header, suggestedEncodings[i])) != null) {
                return encoding;
            }
            ++i;
        }
        return "UTF8";
    }

    private static boolean matches(byte[] header, byte[] suggestedEncodingBytes) {
        if (header.length < suggestedEncodingBytes.length) {
            return false;
        }
        int i = 0;
        while (i < suggestedEncodingBytes.length) {
            if (header[i] != suggestedEncodingBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getJavaEncoding(byte[] header, String suggestedEncoding) throws UnsupportedEncodingException {
        String string = new String(header, suggestedEncoding).toLowerCase().trim();
        if (!string.startsWith(XML_DECL)) {
            return null;
        }
        int index = string.indexOf(ENCODING);
        int endDecl = string.indexOf("?>");
        if (index == -1 || endDecl < index) {
            return suggestedEncoding;
        }
        int equals = string.indexOf(61, index + ENCODING.length());
        int apostrophe = string.indexOf(39, equals);
        int quote = string.indexOf(34, equals);
        int start = apostrophe + 1;
        int delimiter = 39;
        if (equals == -1 || apostrophe == -1 && quote == -1) {
            return suggestedEncoding;
        }
        if (quote != -1 && (apostrophe == -1 || quote < apostrophe)) {
            start = quote + 1;
            delimiter = 34;
        }
        int stop = string.indexOf(delimiter, start);
        return XMLEncodings.getJavaEncoding(string.substring(start, stop));
    }

    public static String getJavaEncoding(String xmlEncoding) {
        String javaEncoding = (String)xmlToJavaEncodings.get(xmlEncoding.toUpperCase());
        return javaEncoding == null ? xmlEncoding : javaEncoding;
    }

    public static String getXMLEncoding(String javaEncoding) {
        String xmlEncoding = (String)javaToXMLEncodings.get(javaEncoding.toUpperCase());
        return xmlEncoding == null ? javaEncoding : xmlEncoding;
    }

    public static void addBidirectionalEncoding(String xmlEncoding, String javaEncoding) {
        xmlToJavaEncodings.put(xmlEncoding, javaEncoding);
        javaToXMLEncodings.put(javaEncoding, xmlEncoding);
    }

    public static void addXMLToJavaEncoding(String xmlEncoding, String javaEncoding) {
        xmlToJavaEncodings.put(xmlEncoding, javaEncoding);
    }

    public static void addJavaToXMLEncoding(String javaEncoding, String xmlEncoding) {
        javaToXMLEncodings.put(javaEncoding, xmlEncoding);
    }

    public static String getSystemEncoding() {
        return systemEncoding;
    }

    public static String getXMLSystemEncoding() {
        return XMLEncodings.getXMLEncoding(systemEncoding);
    }

    private static void initSystemEncoding() {
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
        InputStreamReader reader = new InputStreamReader(input);
        systemEncoding = reader.getEncoding();
        try {
            reader.close();
        }
        catch (IOException exception) {}
    }

    public static void clearSuggestedEncodings() {
        suggestedEncodings = new String[0];
        suggestedEncodingBytes = new byte[0][0];
    }

    public static String[] initSuggestedEncodings(String[] userSuggestedEncodings) {
        XMLEncodings.clearSuggestedEncodings();
        if (suggestedEncodingBytes.length > 0) {
            return new String[0];
        }
        if (userSuggestedEncodings != null || userSuggestedEncodings.length == 0) {
            userSuggestedEncodings = DEFAULT_SUGGESTED_ENCODINGS;
        }
        Vector<String> unsupportedEncodings = new Vector<String>();
        int i = 0;
        while (i < userSuggestedEncodings.length) {
            try {
                XMLEncodings.addSuggestedEncoding(userSuggestedEncodings[i]);
            }
            catch (Throwable exception) {
                unsupportedEncodings.addElement(userSuggestedEncodings[i]);
            }
            ++i;
        }
        Object[] retVal = new String[unsupportedEncodings.size()];
        unsupportedEncodings.copyInto(retVal);
        return retVal;
    }

    public static void initXMLToJavaEncodings() {
        String string = System.getProperty("java.version");
        if (string.equals("1.1") || string.startsWith("1.1.")) {
            XMLEncodings.addXMLToJavaEncoding("SJIS", "WINDOWS-31J");
        } else {
            XMLEncodings.addBidirectionalEncoding("MS932", "WINDOWS-31J");
        }
        XMLEncodings.addBidirectionalEncoding("UTF-8", "UTF8");
        XMLEncodings.addBidirectionalEncoding("US-ASCII", "ASCII");
        XMLEncodings.addBidirectionalEncoding("WINDOWS-1250", "Cp1250");
        XMLEncodings.addBidirectionalEncoding("WINDOWS-1251", "Cp1251");
        XMLEncodings.addBidirectionalEncoding("WINDOWS-1252", "Cp1252");
        XMLEncodings.addBidirectionalEncoding("WINDOWS-1253", "Cp1253");
        XMLEncodings.addBidirectionalEncoding("WINDOWS-1254", "Cp1254");
        XMLEncodings.addBidirectionalEncoding("WINDOWS-1255", "Cp1255");
        XMLEncodings.addBidirectionalEncoding("WINDOWS-1256", "Cp1256");
        XMLEncodings.addBidirectionalEncoding("WINDOWS-1257", "Cp1257");
        XMLEncodings.addBidirectionalEncoding("WINDOWS-1258", "Cp1258");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-US", "CP037");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-DK", "CP277");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-FI", "CP278");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-IT", "CP280");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-ES", "CP284");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-GB", "CP285");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-FR", "CP297");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-AR1", "CP420");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-HE", "CP424");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-CH", "CP500");
        XMLEncodings.addBidirectionalEncoding("CP-AR", "CP868");
        XMLEncodings.addBidirectionalEncoding("CP-GR", "CP869");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-ROECE", "CP870");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-IS", "CP871");
        XMLEncodings.addBidirectionalEncoding("EBCDIC-CP-AR2", "CP918");
        XMLEncodings.addBidirectionalEncoding("TIS-620", "TIS620");
        XMLEncodings.addBidirectionalEncoding("ISO-2022-CN", "ISO2022CN");
        XMLEncodings.addBidirectionalEncoding("X0201", "JIS0201");
        XMLEncodings.addBidirectionalEncoding("X0208", "JIS0208");
        XMLEncodings.addBidirectionalEncoding("ISO-IR-159", "JIS0212");
        XMLEncodings.addXMLToJavaEncoding("ISO-IR-100", "ISO8859_1");
        XMLEncodings.addXMLToJavaEncoding("ISO_8859-1", "ISO8859_1");
        XMLEncodings.addXMLToJavaEncoding("LATIN1", "ISO8859_1");
        XMLEncodings.addXMLToJavaEncoding("L1", "ISO8859_1");
        XMLEncodings.addXMLToJavaEncoding("IBM819", "ISO8859_1");
        XMLEncodings.addXMLToJavaEncoding("CP819", "ISO8859_1");
        XMLEncodings.addXMLToJavaEncoding("ISO-IR-101", "ISO8859_2");
        XMLEncodings.addXMLToJavaEncoding("ISO_8859-2", "ISO8859_2");
        XMLEncodings.addXMLToJavaEncoding("LATIN2", "ISO8859_2");
        XMLEncodings.addXMLToJavaEncoding("L2", "ISO8859_2");
        XMLEncodings.addXMLToJavaEncoding("ISO-IR-109", "ISO8859_3");
        XMLEncodings.addXMLToJavaEncoding("ISO_8859-3", "ISO8859_3");
        XMLEncodings.addXMLToJavaEncoding("LATIN3", "ISO8859_3");
        XMLEncodings.addXMLToJavaEncoding("L3", "ISO8859_3");
        XMLEncodings.addXMLToJavaEncoding("ISO-IR-110", "ISO8859_4");
        XMLEncodings.addXMLToJavaEncoding("ISO_8859-4", "ISO8859_4");
        XMLEncodings.addXMLToJavaEncoding("LATIN4", "ISO8859_4");
        XMLEncodings.addXMLToJavaEncoding("L4", "ISO8859_4");
        XMLEncodings.addXMLToJavaEncoding("ISO-IR-144", "ISO8859_5");
        XMLEncodings.addXMLToJavaEncoding("ISO_8859-5", "ISO8859_5");
        XMLEncodings.addXMLToJavaEncoding("CYRILLIC", "ISO8859_5");
        XMLEncodings.addXMLToJavaEncoding("ISO-IR-127", "ISO8859_6");
        XMLEncodings.addXMLToJavaEncoding("ISO_8859-6", "ISO8859_6");
        XMLEncodings.addXMLToJavaEncoding("ECMA-114", "ISO8859_6");
        XMLEncodings.addXMLToJavaEncoding("ASMO-708", "ISO8859_6");
        XMLEncodings.addXMLToJavaEncoding("ARABIC", "ISO8859_6");
        XMLEncodings.addXMLToJavaEncoding("ISO-IR-126", "ISO8859_7");
        XMLEncodings.addXMLToJavaEncoding("ISO_8859-7", "ISO8859_7");
        XMLEncodings.addXMLToJavaEncoding("ELOT_928", "ISO8859_7");
        XMLEncodings.addXMLToJavaEncoding("ECMA-118", "ISO8859_7");
        XMLEncodings.addXMLToJavaEncoding("GREEK", "ISO8859_7");
        XMLEncodings.addXMLToJavaEncoding("GREEK8", "ISO8859_7");
        XMLEncodings.addXMLToJavaEncoding("ISO-IR-138", "ISO8859_8");
        XMLEncodings.addXMLToJavaEncoding("ISO_8859-8", "ISO8859_8");
        XMLEncodings.addXMLToJavaEncoding("HEBREW", "ISO8859_8");
        XMLEncodings.addXMLToJavaEncoding("ISO-IR-148", "ISO8859_9");
        XMLEncodings.addXMLToJavaEncoding("ISO_8859-9", "ISO8859_9");
        XMLEncodings.addXMLToJavaEncoding("LATIN5", "ISO8859_9");
        XMLEncodings.addXMLToJavaEncoding("L5", "ISO8859_9");
        XMLEncodings.addXMLToJavaEncoding("ISO-2022-JP", "ISO2022JP");
        XMLEncodings.addXMLToJavaEncoding("SHIFT_JIS", "SJIS");
        XMLEncodings.addXMLToJavaEncoding("MS_Kanji", "SJIS");
        XMLEncodings.addXMLToJavaEncoding("ISO-2022-KR", "ISO2022KR");
        XMLEncodings.addXMLToJavaEncoding("EBCDIC-CP-CA", "CP037");
        XMLEncodings.addXMLToJavaEncoding("EBCDIC-CP-NL", "CP037");
        XMLEncodings.addXMLToJavaEncoding("EBCDIC-CP-WT", "CP037");
        XMLEncodings.addXMLToJavaEncoding("EBCDIC-CP-NO", "CP277");
        XMLEncodings.addXMLToJavaEncoding("EBCDIC-CP-SE", "CP278");
        XMLEncodings.addXMLToJavaEncoding("EBCDIC-CP-BE", "CP500");
        XMLEncodings.addXMLToJavaEncoding("EBCDIC-CP-YU", "CP870");
        XMLEncodings.addXMLToJavaEncoding("X0212", "JIS0212");
        XMLEncodings.addJavaToXMLEncoding("ISO8859_1", "ISO-8859-1");
        XMLEncodings.addJavaToXMLEncoding("ISO8859_2", "ISO-8859-2");
        XMLEncodings.addJavaToXMLEncoding("ISO8859_3", "ISO-8859-3");
        XMLEncodings.addJavaToXMLEncoding("ISO8859_4", "ISO-8859-4");
        XMLEncodings.addJavaToXMLEncoding("ISO8859_5", "ISO-8859-5");
        XMLEncodings.addJavaToXMLEncoding("ISO8859_6", "ISO-8859-6");
        XMLEncodings.addJavaToXMLEncoding("ISO8859_7", "ISO-8859-7");
        XMLEncodings.addJavaToXMLEncoding("ISO8859_8", "ISO-8859-8");
        XMLEncodings.addJavaToXMLEncoding("ISO8859_9", "ISO-8859-9");
        XMLEncodings.addJavaToXMLEncoding("ISO2022JP", "ISO-2022-JP");
        XMLEncodings.addJavaToXMLEncoding("SJIS", "Shift_JIS");
        XMLEncodings.addJavaToXMLEncoding("MS932", "WINDOWS-31J");
        XMLEncodings.addJavaToXMLEncoding("EUC_JP", "EUC-JP");
        XMLEncodings.addJavaToXMLEncoding("EUC_KR", "EUC-KR");
        XMLEncodings.addJavaToXMLEncoding("ISO2022KR", "ISO-2022-KR");
        XMLEncodings.addJavaToXMLEncoding("KOI8_R", "KOI8-R");
        XMLEncodings.addJavaToXMLEncoding("JIS0212", "ISO-IR-159");
    }

    static {
        XMLEncodings.initSystemEncoding();
        XMLEncodings.initXMLToJavaEncodings();
    }
}

