/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server.sql;

import electric.sql.SQLClient;
import electric.sql.mapping.ITable;
import electric.uddi.Binding;
import electric.uddi.Category;
import electric.uddi.Description;
import electric.uddi.Service;
import electric.uddi.server.sql.BindingTable;
import electric.uddi.server.sql.CategoryTable;
import electric.uddi.server.sql.DescriptionTable;
import electric.util.WrappedException;
import electric.util.array.ArrayUtil;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ServiceTable
implements ITable {
    private SQLClient sqlClient;
    private BindingTable bindingTable;
    private CategoryTable categoryTable;
    private DescriptionTable descriptionTable;

    public ServiceTable(String databaseName) {
        this(new SQLClient(databaseName));
    }

    public ServiceTable(SQLClient sqlClient) {
        this.sqlClient = sqlClient;
        this.initTables();
    }

    private void initTables() {
        this.descriptionTable = new DescriptionTable(this.sqlClient);
        this.bindingTable = new BindingTable(this.sqlClient);
        this.categoryTable = new CategoryTable(this.sqlClient);
    }

    public void insert(Object value) throws SQLException {
        Service service = (Service)value;
        String serviceKey = service.getServiceKey();
        String businessKey = service.getBusinessKey();
        String name = service.getName();
        String userName = service.getUserName();
        Description[] descriptions = service.getDescriptions();
        Category[] categories = service.getCategories();
        this.insert(serviceKey, businessKey, name, userName);
        this.descriptionTable.insert(descriptions, serviceKey);
        this.categoryTable.insert(categories, serviceKey, null);
    }

    private void insert(String serviceKey, String businessKey, String name, String userName) throws SQLException {
        String sql = "INSERT into service (SERVICE_KEY, BUSINESS_KEY, NAME, USER_NAME) VALUES ('" + serviceKey + "','" + businessKey + "','" + name + "','" + userName + "')";
        this.sqlClient.insert(sql);
    }

    void insert(Service[] services, String businessKey) throws SQLException {
        String[] inserts = new String[services.length];
        int i = 0;
        while (i < services.length) {
            String serviceKey = services[i].getServiceKey();
            String name = services[i].getName();
            Category[] categories = services[i].getCategories();
            Description[] descriptions = services[i].getDescriptions();
            inserts[i] = "INSERT into service (SERVICE_KEY, BUSINESS_KEY, NAME) VALUES ('" + serviceKey + "','" + businessKey + "','" + name + "')";
            this.sqlClient.insert(inserts[i]);
            this.descriptionTable.insert(descriptions, serviceKey);
            this.categoryTable.insert(categories, serviceKey, null);
            ++i;
        }
    }

    public Object select(Object key) throws SQLException {
        String serviceKey = (String)key;
        Service service = this.selectService(serviceKey);
        Description[] descriptions = this.descriptionTable.select(serviceKey);
        Binding[] bindings = this.bindingTable.selectBindings(serviceKey);
        Category[] categories = this.categoryTable.select(serviceKey);
        service.setBindings(bindings);
        service.setDescriptions(descriptions);
        service.setCategories(categories);
        return service;
    }

    private Service selectService(String serviceKey) throws WrappedException {
        Service service = null;
        String query = "SELECT BUSINESS_KEY, NAME, USER_NAME  from service where SERVICE_KEY = '" + serviceKey + "'";
        try {
            ResultSet rs = this.sqlClient.select(query);
            if (rs.next()) {
                String businessKey = rs.getString(1);
                String name = rs.getString(2);
                String userName = rs.getString(3);
                service = new Service(name);
                service.setServiceKey(serviceKey);
                service.setBusinessKey(businessKey);
                service.setUserName(userName);
            }
            return service;
        }
        catch (SQLException exception) {
            throw new WrappedException(exception);
        }
    }

    Service[] selectServices(String businessKey) throws WrappedException {
        Service[] services = new Service[]{};
        String query = "SELECT * from service where BUSINESS_KEY = '" + businessKey + "'";
        try {
            ResultSet rs = this.sqlClient.select(query);
            while (rs.next()) {
                String serviceKey = rs.getString("SERVICE_KEY");
                String name = rs.getString("NAME");
                Service service = new Service(name);
                service.setServiceKey(serviceKey);
                service.setBusinessKey(businessKey);
                services = (Service[])ArrayUtil.addElement(services, service);
            }
            return services;
        }
        catch (SQLException exception) {
            throw new WrappedException(exception);
        }
    }

    public void delete(Object key) throws SQLException {
        String serviceKey = (String)key;
        String[] sql = new String[]{"DELETE from SERVICE where SERVICE_KEY = '" + serviceKey + "'", "DELETE from CATEGORY where CATEGORY_KEY = '" + serviceKey + "'"};
        Binding[] bindings = this.bindingTable.selectBindings(serviceKey);
        this.bindingTable.delete(bindings);
        this.sqlClient.execute(sql);
    }

    void delete(Service[] services) throws SQLException {
        int i = 0;
        while (i < services.length) {
            String serviceKey = services[i].getServiceKey();
            String[] stmts = new String[]{"DELETE from SERVICE where SERVICE_KEY = '" + serviceKey + "'", "DELETE from CATEGORY where CATEGORY_KEY = '" + serviceKey + "'"};
            Binding[] bindings = services[i].getBindings();
            this.bindingTable.delete(bindings);
            this.sqlClient.execute(stmts);
            ++i;
        }
    }

    public void clear() throws SQLException {
        ResultSet rs = this.sqlClient.select("SELECT SERVICE_KEY from SERVICE");
        while (rs.next()) {
            this.delete(rs.getString(1));
        }
    }
}

