/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.registry;

import electric.proxy.IReference;
import electric.registry.IRegistry;
import electric.registry.IRegistryListener;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.registry.directory.DirectoryRegistry;
import electric.server.IServer;
import electric.server.Servers;
import electric.service.IService;
import electric.uddi.AccessPoint;
import electric.uddi.Binding;
import electric.uddi.Business;
import electric.uddi.BusinessInfos;
import electric.uddi.Category;
import electric.uddi.Description;
import electric.uddi.Name;
import electric.uddi.Overview;
import electric.uddi.Service;
import electric.uddi.ServiceInfos;
import electric.uddi.TModel;
import electric.uddi.TModelInfos;
import electric.uddi.TModelInstance;
import electric.uddi.UDDIException;
import electric.uddi.client.UDDIClient;
import electric.util.Context;
import electric.util.XURL;
import electric.wsdl.util.SignatureGenerator;
import java.util.Hashtable;

public class UDDIRegistry
implements IRegistry,
IRegistryListener {
    private Hashtable pathToServiceKey = new Hashtable();
    private UDDIClient uddi;
    private String businessName;
    private String businessKey;

    public UDDIRegistry(String inquiryURL, String publicationURL, String user, String password) throws UDDIException {
        this.uddi = new UDDIClient(inquiryURL, publicationURL, user, password);
        Registry.addListener("uddi", this);
    }

    public UDDIClient getUDDIClient() {
        return this.uddi;
    }

    public IReference bind(String path, Class[] interfaces, Context context) throws RegistryException {
        return null;
    }

    public boolean publish(String path, Object object, Context context) throws RegistryException {
        return false;
    }

    public boolean unpublish(String path) throws RegistryException {
        return false;
    }

    public void published(IRegistry registry, String path, Object object, Context context2) {
        if (!(registry instanceof DirectoryRegistry) && !(object instanceof IService)) {
            return;
        }
        IService service = (IService)object;
        Context context = service.getContext();
        if (context.getProperty("uddiAutoPublish") == null) {
            return;
        }
        try {
            this.publishService(path, service, context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void publishService(String path, IService service, Context context) throws Exception {
        String endpoint = Registry.getPath(service);
        String tModelKey = this.getTModelKey(service, context, endpoint);
        String businessKey = this.getBusinessKey();
        Service uddiService = this.getService(businessKey, path);
        uddiService = this.updateService(uddiService, tModelKey, endpoint);
        this.pathToServiceKey.put(path, uddiService.getServiceKey());
    }

    private String getTModelKey(IService service, Context context, String endpoint) throws Exception {
        String tModelKey = context.getStringProperty("tModel");
        if (tModelKey != null) {
            return tModelKey;
        }
        String wsdlSignature = SignatureGenerator.getSignature(service.getWSDL());
        Category category = new Category("wsdlSignature", wsdlSignature);
        Category[] categories = new Category[]{category};
        TModelInfos tModelInfos = this.uddi.findTModels(null, null, categories, null);
        if (tModelInfos.list.length > 0) {
            return tModelInfos.list[0].getTModelKey();
        }
        TModel tModel = new TModel("xxx");
        tModel.addCategory(category);
        Overview overview = new Overview();
        overview.setOverviewURL(endpoint + ".wsdl");
        tModel.setOverview(overview);
        tModel = this.uddi.saveTModel(tModel);
        return tModel.getTModelKey();
    }

    private synchronized String getBusinessKey() throws Exception {
        if (this.businessKey != null) {
            return this.businessKey;
        }
        String businessName = this.getBusinessName();
        Name[] businessNames = new Name[]{new Name(businessName)};
        BusinessInfos businessInfos = this.uddi.findBusinesses(businessNames, null, null, null, null, null);
        if (businessInfos.list.length > 0) {
            return businessInfos.list[0].getBusinessKey();
        }
        Business business = new Business(businessName);
        business = this.uddi.saveBusiness(business);
        this.businessKey = business.getBusinessKey();
        return this.businessKey;
    }

    private synchronized String getBusinessName() {
        if (this.businessName != null) {
            return this.businessName;
        }
        IServer[] servers = Servers.getServersForProtocol("http");
        XURL xurl = servers[0].getPath();
        this.businessName = xurl.getHost() + ":" + xurl.getPort();
        return this.businessName;
    }

    private Service getService(String businessKey, String path) throws Exception {
        Name[] names = new Name[]{new Name(path)};
        ServiceInfos serviceInfos = this.uddi.findServices(businessKey, names, null, null, null);
        if (serviceInfos.list.length > 0) {
            return this.uddi.getService(serviceInfos.list[0].getServiceKey());
        }
        Service service = new Service(path);
        service.setBusinessKey(businessKey);
        return service;
    }

    private Service updateService(Service service, String tModelKey, String endpoint) throws Exception {
        Binding binding = new Binding();
        TModelInstance tModelInstance = new TModelInstance(tModelKey);
        binding.addTModelInstance(tModelInstance);
        binding.addDescription(new Description("XXX DESCRIPTION XXX"));
        AccessPoint accessPoint = new AccessPoint(endpoint, "http");
        binding.setAccessPoint(accessPoint);
        Binding[] bindings = new Binding[]{binding};
        service.setBindings(bindings);
        Category altWSDL = new Category("serviceWSDL", endpoint + ".wsdl");
        Category[] categories = new Category[]{altWSDL};
        service.setCategories(categories);
        service = this.uddi.saveService(service);
        System.out.println("service = " + service);
        return service;
    }

    public void unpublished(IRegistry registry, String path, Object object) {
        System.out.println("UNPUBLISH " + path);
        if (!(registry instanceof DirectoryRegistry)) {
            return;
        }
        String serviceKey = (String)this.pathToServiceKey.get(path);
        if (serviceKey == null) {
            return;
        }
        try {
            System.out.println("DELETE SERVICE " + serviceKey);
            this.uddi.deleteService(serviceKey);
        }
        catch (Exception exception) {
            System.out.println("ERROR DURING SERVICE DELETION... " + exception);
        }
    }
}

