/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Business;
import electric.uddi.IUDDIConstants;
import electric.uddi.IUDDIServer;
import electric.uddi.Identifier;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.util.array.ArrayUtil;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public final class Assertion
implements ISerializable,
IUDDIConstants {
    private String fromKey;
    private String toKey;
    private Identifier keyedReference;
    private String fromUserName;
    private String toUserName;
    private String userName;

    public Assertion() {
    }

    public Assertion(Business fromBusiness, Business toBusiness, Identifier keyedReference) {
        this(fromBusiness.getBusinessKey(), toBusiness.getBusinessKey(), keyedReference);
    }

    public Assertion(String fromKey, String toKey, Identifier keyedReference) {
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.keyedReference = keyedReference;
    }

    public String toString() {
        try {
            LiteralWriter writer = new LiteralWriter(new Element("publisherAssertion"));
            this.write(writer);
            return writer.getElement().getFirstElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Assertion)) {
            return false;
        }
        Assertion assertion = (Assertion)object;
        if (!ArrayUtil.equals(this.fromKey, assertion.fromKey)) {
            return false;
        }
        if (!ArrayUtil.equals(this.toKey, assertion.toKey)) {
            return false;
        }
        return ArrayUtil.equals(this.keyedReference, assertion.keyedReference);
    }

    public void setFromKey(String fromKey) {
        this.fromKey = fromKey;
    }

    public String getFromKey() {
        return this.fromKey;
    }

    public void setToKey(String toKey) {
        this.toKey = toKey;
    }

    public String getToKey() {
        return this.toKey;
    }

    public String getRelatedKey(String businessKey) {
        if (businessKey.equals(this.fromKey)) {
            return this.toKey;
        }
        if (businessKey.equals(this.toKey)) {
            return this.fromKey;
        }
        return null;
    }

    public Identifier getKeyedReference() {
        return this.keyedReference;
    }

    public void setKeyedReference(Identifier keyedReference) {
        this.keyedReference = keyedReference;
    }

    public String getAssertionKey() {
        return this.fromKey + this.toKey + this.keyedReference.getName() + this.keyedReference.getValue() + this.keyedReference.getTModelKey();
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public String getToUserName() {
        return this.toUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public void assertUser(IUDDIServer server, User user) throws UDDIException {
        if (!server.ownsBusiness(this.fromKey, user) && !server.ownsBusiness(this.toKey, user)) {
            throw new UDDIException(10140);
        }
        if (server.ownsBusiness(this.fromKey, user)) {
            this.fromUserName = user.getName();
        }
        if (server.ownsBusiness(this.toKey, user)) {
            this.toUserName = user.getName();
        }
    }

    public void unassertUser(IUDDIServer server, User user) throws UDDIException {
        if (!server.publishedAssertion(this, user)) {
            throw new UDDIException(30000);
        }
        if (!server.ownsBusiness(this.fromKey, user) && !server.ownsBusiness(this.toKey, user)) {
            throw new UDDIException(10140);
        }
        if (server.ownsBusiness(this.fromKey, user)) {
            this.fromUserName = null;
        }
        if (server.ownsBusiness(this.toKey, user)) {
            this.toUserName = null;
        }
    }

    public String getStatus() {
        if (this.fromUserName == null) {
            return "status:fromKey_incomplete";
        }
        if (this.toUserName == null) {
            return "status:toKey_incomplete";
        }
        return "status:complete";
    }

    public boolean hasNoUsers() {
        return this.fromUserName == null && this.toUserName == null;
    }

    public boolean matches(String status, String[] businessKeys, Identifier reference) {
        if (status != null && !status.equals(this.getStatus())) {
            return false;
        }
        int i = 0;
        while (i < businessKeys.length) {
            if (!businessKeys[i].equals(this.fromKey) && !businessKeys[i].equals(this.toKey)) {
                return false;
            }
            ++i;
        }
        return reference == null || reference.equals(this.keyedReference);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void write(IWriter writer) throws IOException {
        this.write(writer, true, true);
    }

    public void write(IWriter writer, boolean publish, boolean includeUserName) throws IOException {
        IWriter assertion = writer.writeElement("publisherAssertion");
        if (includeUserName && this.userName != null) {
            assertion.writeAttribute("userName", this.userName);
        }
        assertion.writeString("fromKey", this.getFromKey());
        assertion.writeString("toKey", this.getToKey());
        this.keyedReference.write(assertion);
        if (publish && this.fromUserName != null) {
            assertion.writeString("fromUser", this.fromUserName);
        }
        if (publish && this.toUserName != null) {
            assertion.writeString("toUser", this.toUserName);
        }
    }

    public void read(IReader reader) throws IOException {
        this.userName = reader.readAttributeValue("userName");
        this.fromKey = reader.readString("fromKey");
        this.toKey = reader.readString("toKey");
        IReader keyedRef = reader.getReader("keyedReference");
        this.keyedReference = new Identifier();
        this.keyedReference.read(keyedRef);
        this.fromUserName = reader.readString("fromUser");
        this.toUserName = reader.readString("toUser");
    }
}

