/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.transaction.Transaction;
import electric.uddi.Assertion;
import electric.uddi.Authorization;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class AddAssertions
implements IPublicationCommand {
    private Assertion[] assertions = new Assertion[0];
    static /* synthetic */ Class class$electric$uddi$Assertion;

    public AddAssertions() {
    }

    public AddAssertions(Assertion[] assertions) {
        this.assertions = assertions;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            int i = 0;
            while (i < this.assertions.length) {
                AddAssertions.addAssertion(server, this.assertions[i], user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return null;
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    public static void addAssertion(IUDDIServer server, Assertion assertion, User user) throws UDDIException {
        if (server.publishedAssertion(assertion, user)) {
            return;
        }
        server.readBusiness(assertion.getFromKey());
        server.readBusiness(assertion.getToKey());
        server.readTModel(assertion.getKeyedReference().getTModelKey());
        try {
            Assertion existingAssertion = server.readAssertion(assertion.getAssertionKey());
            existingAssertion.assertUser(server, user);
            server.writeAssertion(existingAssertion);
        }
        catch (UDDIException exception) {
            assertion.setUserName(user.getName());
            assertion.assertUser(server, user);
            server.writeAssertion(assertion);
        }
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("add_publisherAssertions");
        UDDIUtil.writeList(query, this.assertions);
    }

    public void read(IReader reader) throws IOException {
        IReader[] readers = reader.getReaders("publisherAssertion");
        this.assertions = (Assertion[])UDDIUtil.readList(readers, class$electric$uddi$Assertion == null ? (class$electric$uddi$Assertion = AddAssertions.class$("electric.uddi.Assertion")) : class$electric$uddi$Assertion);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

