/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.soap.SOAPException;
import electric.soap.wsdl.SOAPMessageDecl;
import electric.util.Value;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Message;
import electric.xml.io.IReader;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.accessors.FieldAccessor;
import electric.xml.io.accessors.ObjectAccessor;
import electric.xml.io.array.ArrayType;
import electric.xml.io.complex.ComplexContent;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.model.All;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.simple.SimpleType;
import java.rmi.RemoteException;

public class SOAPFault
implements IWSDLConstants {
    public static RemoteException parseFault(SOAPMessageDecl faultDecl, String declaredFaultName, IReader reader) {
        reader = reader.getReader("detail");
        SchemaElement element = faultDecl.messageDecl.getMessage().getParts()[0].getSchemaElement();
        if (element != null) {
            return SOAPFault.parseElementFault(element, reader);
        }
        Type partType = faultDecl.messageDecl.getMessage().getPart(0).getType();
        if (partType instanceof ArrayType) {
            return SOAPFault.parseArrayFault(faultDecl.messageDecl.getMessage(), partType, declaredFaultName, reader);
        }
        if (partType instanceof SimpleType) {
            return SOAPFault.parseSimpleFault(faultDecl.messageDecl.getMessage(), partType, declaredFaultName, reader);
        }
        return SOAPFault.parseComplexFault(partType, declaredFaultName, reader);
    }

    private static RemoteException parseSimpleFault(Message partMessage, Type partType, String declaredFaultName, IReader reader) {
        try {
            ComplexType complexType = SOAPFault.mapSimpleFaultToType(partMessage, partType);
            ComplexContent complexContent = (ComplexContent)complexType.getModel();
            All all = (All)complexContent.getModel();
            SchemaElement childElement = all.getElements()[0];
            SchemaElement element = new SchemaElement(declaredFaultName, childElement.getType(), false);
            Class javaClass = partType.getJavaClass();
            Object object = javaClass.newInstance();
            FieldAccessor fieldAccessor = new FieldAccessor(all.getElements()[0], childElement.getName());
            element.setAccessor(fieldAccessor);
            Value value = new Value();
            value.object = object;
            element.readObject(reader, value);
            Throwable exception = (Throwable)value.getObject();
            return new SOAPException(exception);
        }
        catch (Throwable exception) {
            return null;
        }
    }

    private static ComplexType mapSimpleFaultToType(Message partMessage, Type partType) throws SchemaException {
        String partNamespace = partType.getNamespace();
        String partName = partMessage.getName();
        Namespaces partNamespaces = partType.getNamespaces();
        partType = partNamespaces.getTypeWithQName(partNamespace, partName);
        ComplexType complexType = (ComplexType)partType;
        return complexType;
    }

    private static RemoteException parseArrayFault(Message partMessage, Type partType, String declaredFaultName, IReader reader) {
        try {
            ComplexType complexType = SOAPFault.mapSimpleFaultToType(partMessage, partType);
            ComplexContent complexContent = (ComplexContent)complexType.getModel();
            All all = (All)complexContent.getModel();
            SchemaElement childElement = all.getElements()[0];
            SchemaElement element = new SchemaElement(declaredFaultName, partType, false);
            Class javaClass = partType.getJavaClass();
            Object object = javaClass.newInstance();
            FieldAccessor fieldAccessor = new FieldAccessor(all.getElements()[0], childElement.getName());
            element.setAccessor(fieldAccessor);
            Value value = new Value();
            value.object = object;
            element.readObject(reader, value);
            Throwable exception = (Throwable)value.getObject();
            return new SOAPException(exception);
        }
        catch (Throwable exception) {
            return null;
        }
    }

    private static RemoteException parseComplexFault(Type partType, String declaredFaultName, IReader reader) {
        try {
            SchemaElement element = new SchemaElement(declaredFaultName, partType, false);
            element.setAccessor(new ObjectAccessor(null));
            Value value = new Value();
            element.readObject(reader, value);
            Throwable exception = (Throwable)value.getObject();
            return new SOAPException(exception);
        }
        catch (Throwable exception) {
            return null;
        }
    }

    private static RemoteException parseElementFault(SchemaElement element, IReader reader) {
        try {
            Value value = new Value();
            element.readObject(reader, value);
            Throwable exception = (Throwable)value.getObject();
            return new SOAPException(exception);
        }
        catch (Throwable exception) {
            return null;
        }
    }
}

