/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.util;

import electric.soap.ISOAPConstants;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.util.Context;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Enumeration;

public final class SOAPHeaders
implements ISOAPConstants {
    public static void checkHeaders(SOAPMessage message, Context messageContext) throws SOAPException {
        if (message.getOptimizations().getEnvelopeOmission()) {
            return;
        }
        Elements headerElements = message.getHeaderElements();
        while (headerElements.hasMoreElements()) {
            SOAPHeaders.checkMustUnderstand(headerElements.next(), messageContext);
        }
    }

    public static void checkMustUnderstand(Element headerElement, Context messageContext) throws SOAPException {
        String value = headerElement.getAttributeValue("mustUnderstand");
        if (value == null || "0".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return;
        }
        Enumeration understoodElements = messageContext.getProperties("understood");
        while (understoodElements.hasMoreElements()) {
            if (understoodElements.nextElement() != headerElement) continue;
            return;
        }
        throw new SOAPException("SOAP Must Understand Error", "MustUnderstand");
    }
}

