/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.handlers;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ThreadContext;
import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.handlers.chain.ChainedSOAPHandler;
import electric.soap.security.IWSSConstants;
import electric.soap.security.IWSSContextConstants;
import electric.soap.security.SOAPSecurityException;
import electric.soap.security.WSSContext;
import electric.soap.security.encryption.WSSEncryptionProcessor;
import electric.soap.security.signature.WSSSignatureProcessor;
import electric.soap.security.tokens.SecurityTokenProcessor;
import electric.soap.security.util.SecurityXPathFactory;
import electric.util.Context;
import electric.util.XURL;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXMLConstants;
import electric.xml.IXPath;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;

public class SecurityHandler
extends ChainedSOAPHandler
implements IWSSConstants,
IWSSContextConstants,
ISOAPConstants,
IXMLConstants,
IGLUELoggingConstants,
IGLUEContextConstants {
    protected IService service;
    protected SecurityTokenProcessor tokenProcessor;
    protected WSSSignatureProcessor signatureProcessor;
    protected WSSEncryptionProcessor encryptionProcessor;

    public SecurityHandler(IService service, ISOAPHandler nextHandler) {
        super(nextHandler);
        this.service = service;
        this.tokenProcessor = new SecurityTokenProcessor();
        this.signatureProcessor = new WSSSignatureProcessor(this.tokenProcessor);
        this.encryptionProcessor = new WSSEncryptionProcessor(this.tokenProcessor);
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        Context serviceContext = this.service.getContext();
        WSSContext wss = (WSSContext)serviceContext.getProperty("wssContext");
        if (wss == null || !WSSContext.isEnabled()) {
            return this.nextHandler.handle(request, messageContext);
        }
        return this.handleSecurity(request, wss, messageContext);
    }

    private SOAPMessage handleSecurity(SOAPMessage request, WSSContext wss, Context messageContext) throws SOAPException {
        SOAPMessage response;
        block5: {
            response = null;
            try {
                request.deoptimize();
                this.handleMustUnderstand(request, messageContext);
                this.incoming(request, wss, messageContext);
                response = this.nextHandler.handle(request, messageContext);
                if (response == null) {
                    return null;
                }
                response.deoptimize();
                Element securityElement = response.getHeaderElement("http://schemas.xmlsoap.org/ws/2002/12/secext", "Security");
                if (securityElement == null) {
                    securityElement = new Element("wsse", "Security", "http://schemas.xmlsoap.org/ws/2002/12/secext");
                    securityElement.setAttributeNS("xmlns", "xmlns:wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
                    Element msgHeader = response.addHeader();
                    msgHeader.addChild(securityElement);
                }
                this.outgoing(response, wss, securityElement);
            }
            catch (SOAPException soapException) {
                throw soapException;
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "problem in security handler", exception);
            }
        }
        return response;
    }

    private void outgoing(SOAPMessage message, WSSContext wss, Element securityElement) throws SOAPSecurityException, Exception {
        ThreadContext.removeProperty("wssTokens");
        this.tokenProcessor.addTokens(message, wss, securityElement);
        Hashtable tokenToId = new Hashtable();
        this.signatureProcessor.addTokens(message, wss, securityElement, tokenToId);
        this.signatureProcessor.addSignatures(message, wss, securityElement);
        this.encryptionProcessor.addEncryptionCertificates(message, wss, securityElement, tokenToId);
        this.encryptionProcessor.addEncryptions(message, wss, securityElement, tokenToId);
    }

    private void incoming(SOAPMessage message, WSSContext wss, Context messageContext) throws SOAPException {
        Vector tokenList = this.tokenProcessor.readTokens(message, wss);
        Context threadContext = Context.thread();
        int i = 0;
        while (i < tokenList.size()) {
            threadContext.addProperty("wssTokens", tokenList.elementAt(i));
            ++i;
        }
        Vector principalList = new Vector();
        boolean authorized = wss.in.authenticate(message, tokenList, principalList);
        Vector encryptions = new Vector();
        this.encryptionProcessor.decrypt(message, encryptions, wss.in.guards());
        if (authorized) {
            Vector signatures = new Vector();
            boolean valid = this.signatureProcessor.validateSignatures(message, wss, signatures, tokenList);
            authorized = !valid ? false : wss.in.authorize(message, signatures, encryptions, principalList);
        }
        if (!authorized) {
            this.logAuthFailure(message, messageContext);
            String detail = "<detail>SECURITY EXCEPTION</detail>";
            throw new SOAPException("security", "Server", null, detail);
        }
    }

    private void logAuthFailure(SOAPMessage message, Context messageContext) {
        String serviceLocation = "unknown";
        String messageSource = "unknown";
        if (messageContext != null) {
            XURL endpoint = (XURL)messageContext.getProperty("endpoint");
            if (endpoint != null) {
                serviceLocation = endpoint.toString();
            }
            messageSource = messageContext.getStringProperty("transportSource");
        }
        if (Log.isLogging(ILoggingConstants.SECURITY_EVENT)) {
            Log.log(ILoggingConstants.SECURITY_EVENT, (Object)("authorization failed for message from:" + messageSource + " to:" + serviceLocation));
        }
        if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)("authorization failed, message detail:" + message.toString()));
        }
    }

    protected void handleMustUnderstand(SOAPMessage message, Context messageContext) {
        block3: {
            try {
                Document doc = message.getDocument();
                IXPath xpath = SecurityXPathFactory.createXPath("/soap:Envelope/soap:Header/wsse:Security");
                xpath.setNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/");
                xpath.setNamespace("wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
                Element headerElement = xpath.getElement(doc.getRoot());
                if (headerElement != null) {
                    messageContext.addProperty("understood", headerElement);
                }
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "problem with mustunderstand", exception);
            }
        }
    }
}

