/*
 * Decompiled with CFR 0.152.
 */
package electric.soap;

import electric.soap.ISOAPConstants;
import electric.soap.SOAPException;
import electric.soap.SOAPOptimizations;
import electric.soap.util.SOAPEnvelopes;
import electric.soap.wsdl.WSDLTagData;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.array.ByteArray;
import electric.util.context.IContextHolder;
import electric.util.io.FastStringReader;
import electric.util.mime.IMIMEConstants;
import electric.util.mime.MIMEData;
import electric.util.mime.MIMEHeaders;
import electric.util.string.Strings;
import electric.wsdl.WSDL;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.NodeList;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.ParseException;
import electric.xml.Selection;
import electric.xml.substitute.SubstituteReader;
import electric.xml.substitute.SubstituteWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public final class SOAPMessage
implements ISOAPConstants,
IMIMEConstants,
IContextHolder {
    private static final Elements NO_ELEMENTS = new Elements(new NodeList());
    private Document document;
    private MIMEData[] attachments;
    private MIMEHeaders headers;
    private SOAPOptimizations optimizations = SOAPOptimizations.DEFAULT;
    private String attachmentStyle = "mime";
    private Context messageContext = new Context();
    private String soapVersion = "http://schemas.xmlsoap.org/soap/envelope/";

    public SOAPMessage() {
    }

    public SOAPMessage(Throwable exception) {
        this.setException(exception);
    }

    public String toString() {
        return this.document == null ? "no document" : this.document.toString(2);
    }

    public int size() {
        int size = 0;
        size += this.document.size();
        if (this.attachments != null) {
            int i = 0;
            while (i < this.attachments.length) {
                size += this.attachments[i].getContentLength();
                ++i;
            }
        }
        return size;
    }

    public SOAPOptimizations getOptimizations() {
        return this.optimizations;
    }

    public void deoptimize() {
        if (this.optimizations.getEnvelopeOmission()) {
            Document oldDocument = this.getDocument();
            this.document = SOAPEnvelopes.newEncodedEnvelope(null, this.soapVersion);
            this.optimizations.setEnvelopeOmission(false);
            this.getBody().addElement(oldDocument.getRoot());
        }
        if (this.optimizations.getTagSubstitution()) {
            this.optimizations.setTagSubstitution(false);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getRoot() {
        return this.document == null ? null : this.document.getRoot();
    }

    public void setDocument(Document document) {
        this.document = document;
        this.optimizations = SOAPOptimizations.DEFAULT;
    }

    public void setDocument(Document document, SOAPOptimizations optimizations) {
        this.document = document;
        this.optimizations = optimizations;
    }

    public ByteArray getByteArray() throws IOException {
        return this.document.getByteArray(new NodeWriter(null, -1, !this.optimizations.hasOptimizations()));
    }

    public ByteArray getByteArray(WSDL wsdl) throws IOException {
        if (this.optimizations.getTagSubstitution() && wsdl != null) {
            return this.document.getByteArray(new SubstituteWriter(null, -1, false, WSDLTagData.getTagData(wsdl)));
        }
        return this.getByteArray();
    }

    public byte[] getBytes() throws IOException {
        if (this.optimizations.hasOptimizations()) {
            return this.document.getBytes();
        }
        return this.document.getBytes(true);
    }

    public void setBytes(byte[] bytes) throws ParseException {
        this.setDocument(new Document(bytes));
    }

    public void setBytes(byte[] bytes, SOAPOptimizations optimizations, WSDL wsdl) throws ParseException, UnsupportedEncodingException {
        this.optimizations = optimizations;
        FastStringReader reader = new FastStringReader(Strings.toString(bytes));
        NodeReader nodeReader = null;
        nodeReader = optimizations.getTagSubstitution() && wsdl != null ? new SubstituteReader(reader, 1, WSDLTagData.getTagData(wsdl)) : new NodeReader(reader, 1);
        this.document = optimizations.getEnvelopeOmission() ? new Document(nodeReader, SOAPEnvelopes.getParseContext()) : new Document(nodeReader);
    }

    public Element getEnvelope() {
        return this.document == null ? null : this.document.getRoot();
    }

    public void setEnvelope(Element envelope) {
        if (this.document == null) {
            this.document = new Document();
        }
        this.document.setRoot(envelope);
    }

    public Element removeEnvelope() {
        Element envelope = this.getEnvelope();
        if (envelope == null) {
            return null;
        }
        envelope.remove();
        return envelope;
    }

    public Element addEnvelope() {
        Element envelope = this.getEnvelope();
        if (envelope != null) {
            return envelope;
        }
        this.document = new Document();
        envelope = this.document.newRoot();
        envelope.setNamespace("soap", this.getEnvelopeNamespace());
        envelope.setName("soap", "Envelope");
        this.optimizations.setEnvelopeOmission(false);
        return envelope;
    }

    public Element getBody() {
        Element envelope = this.getEnvelope();
        if (envelope == null) {
            return null;
        }
        return envelope.getElement(this.getEnvelopeNamespace(), "Body");
    }

    public String getEnvelopeNamespace() {
        if (this.soapVersion != null && this.soapVersion.equals("http://www.w3.org/2003/05/soap-envelope")) {
            return "http://www.w3.org/2003/05/soap-envelope";
        }
        return "http://schemas.xmlsoap.org/soap/envelope/";
    }

    public void setBody(Element body) {
        this.removeBody();
        this.addEnvelope().addElement(body);
    }

    public Element removeBody() {
        Element body = this.getBody();
        if (body == null) {
            return null;
        }
        body.remove();
        return body;
    }

    public Element addBody() {
        Element body = this.getBody();
        if (body != null) {
            return body;
        }
        Element envelope = this.addEnvelope();
        String soapPrefix = envelope.getNamespacePrefix(this.getEnvelopeNamespace());
        return envelope.addElement(soapPrefix, "Body");
    }

    public Element getFault() {
        if (this.optimizations.getEnvelopeOmission()) {
            return null;
        }
        Element body = this.getBody();
        if (body == null) {
            return null;
        }
        return body.getElement(this.getEnvelopeNamespace(), "Fault");
    }

    public void setFault(Element fault) {
        Element body = this.addBody();
        body.removeChildren();
        body.addElement(fault);
    }

    public Element removeFault() {
        Element fault = this.getFault();
        if (fault == null) {
            return null;
        }
        fault.remove();
        return fault;
    }

    public Element addFault() {
        Element fault = this.getFault();
        if (fault != null) {
            return fault;
        }
        Element body = this.addBody();
        body.removeChildren();
        String soapPrefix = body.getNamespacePrefix(this.getEnvelopeNamespace());
        return body.addElement(soapPrefix, "Fault");
    }

    public boolean hasFault() {
        return this.getFault() != null;
    }

    public Throwable getException() {
        SOAPException exception = this.getSOAPException();
        if (exception == null) {
            return null;
        }
        Throwable cause = exception.getCause();
        return cause != null ? cause : exception;
    }

    public SOAPException getSOAPException() {
        Element faultElement = this.getFault();
        if (faultElement == null) {
            return null;
        }
        return new SOAPException(faultElement);
    }

    public boolean isException() {
        return this.getFault() != null;
    }

    public void setException(Throwable exception) {
        Document envelope = SOAPEnvelopes.newEncodedEnvelope(null, this.soapVersion);
        Element fault = envelope.getRoot().getElement("Body").addElement("soap", "Fault");
        if (exception instanceof SOAPException) {
            ((SOAPException)exception).addFields(fault);
        } else {
            new SOAPException(exception).addFields(fault);
        }
        this.setDocument(envelope);
    }

    public Element getHeader() {
        Element envelope = this.getEnvelope();
        if (envelope == null) {
            return null;
        }
        return envelope.getElement(this.getEnvelopeNamespace(), "Header");
    }

    public void setHeader(Element header) {
        this.removeHeader();
        this.addEnvelope().insertElement(header);
    }

    public Element removeHeader() {
        Element header = this.getHeader();
        if (header == null) {
            return null;
        }
        header.remove();
        return header;
    }

    public Element addHeader() {
        Element header = this.getHeader();
        if (header != null) {
            return header;
        }
        Element envelope = this.addEnvelope();
        String soapPrefix = envelope.getNamespacePrefix(this.getEnvelopeNamespace());
        return envelope.insertElement(soapPrefix, "Header");
    }

    public Element getHeaderElement(String name) {
        Element header = this.getHeader();
        if (header == null) {
            return null;
        }
        return header.getElement(name);
    }

    public Element getHeaderElement(String namespace, String name) {
        Element header = this.getHeader();
        if (header == null) {
            return null;
        }
        return header.getElement(namespace, name);
    }

    public Elements getHeaderElements() {
        Element header = this.getHeader();
        if (header == null) {
            return NO_ELEMENTS;
        }
        return header.getElements();
    }

    public Elements getHeaderElementsForSOAPActor(String actor) {
        NodeList selected = new NodeList();
        Elements headers = this.getHeaderElements();
        while (headers.hasMoreElements()) {
            Element header = headers.next();
            if (!header.hasAttribute("actor") || !header.getAttribute("actor").equals(actor)) continue;
            selected.append(new Selection(header));
        }
        return new Elements(selected);
    }

    public Elements getHeaderElements(String name) {
        Element header = this.getHeader();
        if (header == null) {
            return NO_ELEMENTS;
        }
        return header.getElements(name);
    }

    public Elements getHeaderElements(String namespace, String name) {
        Element header = this.getHeader();
        if (header == null) {
            return NO_ELEMENTS;
        }
        return header.getElements(namespace, name);
    }

    public void addHeaderElement(Element element) {
        this.addHeader().addElement(element);
    }

    public void removeHeaderElement(Element element) {
        element.remove();
    }

    public void removeHeaderElement(String name) {
        Element header = this.getHeader();
        if (header == null) {
            return;
        }
        header.removeElement(name);
    }

    public void removeHeaderElement(String namespace, String name) {
        Element header = this.getHeader();
        if (header == null) {
            return;
        }
        header.removeElement(namespace, name);
    }

    public void removeHeaderElements(String name) {
        Element header = this.getHeader();
        if (header == null) {
            return;
        }
        header.removeElements(name);
    }

    public void removeHeaderElements(String namespace, String name) {
        Element header = this.getHeader();
        if (header == null) {
            return;
        }
        header.removeElements(namespace, name);
    }

    public void removeHeaderElements() {
        this.getHeaderElements().remove();
    }

    public MIMEData[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(MIMEData[] attachments) {
        this.attachments = attachments;
    }

    public boolean hasAttachments() {
        return this.attachments != null && this.attachments.length > 0;
    }

    public boolean hasAttachment(String contentID) {
        if (this.attachments == null || contentID == null) {
            return false;
        }
        int i = 0;
        while (i < this.attachments.length) {
            MIMEData attachment = this.attachments[i];
            String attachmentID = attachment.getContentId();
            if (attachmentID != null && contentID.equals(attachmentID) || contentID.equals("cid:" + attachmentID)) {
                return true;
            }
            if (attachment.getContentLabel() != null && attachment.getContentLabel().equals(contentID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addAttachment(MIMEData attachment) {
        if (attachment == null) {
            return;
        }
        this.attachments = this.attachments == null ? new MIMEData[]{attachment} : (MIMEData[])ArrayUtil.addElement(this.attachments, attachment);
    }

    public void removeAttachment(MIMEData attachment) {
        if (this.attachments == null) {
            return;
        }
        this.attachments = (MIMEData[])ArrayUtil.removeElementIdentity(this.attachments, attachment);
    }

    public void removeAttachments() {
        this.attachments = null;
    }

    public String getAttachmentStyle() {
        return this.attachmentStyle;
    }

    public void setAttachmentStyle(String attachmentStyle) {
        this.attachmentStyle = attachmentStyle;
    }

    public void addMIMEHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new MIMEHeaders();
        }
        this.headers.addHeader(name, value);
    }

    public void setMIMEHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new MIMEHeaders();
        }
        this.headers.setHeader(name, value);
    }

    public String getMIMEHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.getHeader(name);
    }

    public Enumeration getMIMEHeaders(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.getHeaders(name);
    }

    public MIMEHeaders getMIMEHeaders() {
        return this.headers;
    }

    public void removeMIMEHeader(String name) {
        if (this.headers == null) {
            return;
        }
        this.headers.removeHeader(name);
    }

    public void removeMIMEHeaders(String name) {
        if (this.headers == null) {
            return;
        }
        this.headers.removeHeaders(name);
    }

    public void removeMIMEHeaders() {
        this.headers = null;
    }

    public String getEncodingStyle() {
        String encodingStyle = null;
        if (this.optimizations.getEnvelopeOmission()) {
            if (this.soapVersion != null && this.soapVersion.equals("http://www.w3.org/2003/05/soap-envelope")) {
                return "http://www.w3.org/2003/05/soap-encoding";
            }
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        if (this.getBody() != null) {
            encodingStyle = this.getBody().getAttributeValue(this.getEnvelopeNamespace(), "encodingStyle");
        }
        if (encodingStyle == null) {
            encodingStyle = this.getEnvelope().getAttributeValue(this.getEnvelopeNamespace(), "encodingStyle");
        }
        return encodingStyle;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public Context getContext() {
        return this.messageContext;
    }

    public void setContext(Context context) {
        this.messageContext = context;
    }
}

