/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.authenticators.basic;

import electric.glue.IGLUELoggingConstants;
import electric.security.IRealm;
import electric.security.credentials.PasswordCredentials;
import electric.servlet.InboundHTTPRequest;
import electric.servlet.authenticators.IHTTPAuthenticator;
import electric.util.array.ArrayUtil;
import electric.util.encoding.StringEncodings;
import electric.util.http.IHTTPConstants;
import electric.util.io.Streams;
import electric.util.string.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicAuthenticator
implements IHTTPAuthenticator,
IHTTPConstants,
IGLUELoggingConstants {
    public String getAuthMethod() {
        return "BASIC";
    }

    public String[] getAuthorizedUsers(InboundHTTPRequest request, IRealm realm, String authHeader) {
        PasswordCredentials[] credentials = this.getCredentials(authHeader);
        String[] users = new String[]{};
        if (credentials == null || credentials.length == 0) {
            return users;
        }
        if (realm.authenticate(credentials[0])) {
            request.setRemoteUser(credentials[0].getUserName());
            users = (String[])ArrayUtil.addElement(users, credentials[0].getUserName());
        }
        return users;
    }

    public PasswordCredentials[] getCredentials(String authHeader) {
        StringTokenizer tokenizer = new StringTokenizer(authHeader);
        String authType = tokenizer.nextToken();
        String value = StringEncodings.fromAssumedEncoding(Base64.fromBase64(tokenizer.nextToken()));
        int index = value.indexOf(58);
        if (index == -1) {
            return null;
        }
        String userName = value.substring(0, index);
        String password = value.substring(index + 1);
        PasswordCredentials credentials = new PasswordCredentials(userName, password);
        PasswordCredentials[] credentialsList = new PasswordCredentials[]{credentials};
        return credentialsList;
    }

    public boolean requestAuthentication(HttpServletRequest request, HttpServletResponse response, IRealm realm) throws IOException {
        String realmName = realm == null ? "null" : realm.getName();
        if (request.getContentLength() != -1) {
            Streams.readFully((InputStream)request.getInputStream(), request.getContentLength());
        }
        response.setStatus(401);
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
        response.setContentLength(0);
        return false;
    }
}

