/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet;

import electric.glue.IGLUELoggingConstants;
import electric.security.IGuard;
import electric.security.IRealm;
import electric.security.Realms;
import electric.security.guards.Authenticate;
import electric.security.guards.path.IPathGuards;
import electric.security.guards.path.PathGuards;
import electric.servlet.Config;
import electric.servlet.ConfigComparator;
import electric.servlet.HTTPContextListeners;
import electric.servlet.IServletConstants;
import electric.servlet.InboundHTTPRequest;
import electric.servlet.MappedServlet;
import electric.servlet.OutboundHTTPResponse;
import electric.servlet.ServletEngine;
import electric.servlet.ServletMapper;
import electric.servlet.authenticators.IHTTPAuthenticator;
import electric.servlet.authenticators.basic.BasicAuthenticator;
import electric.servlet.authenticators.digest.DigestAuthenticator;
import electric.servlet.authorizers.IHTTPAuthorizer;
import electric.servlet.authorizers.servlet.ServletAuthorizer;
import electric.servlet.dispatcher.ServletRequestDispatcher;
import electric.servlet.filters.FilterMapper;
import electric.servlet.filters.ServletFilterChain;
import electric.servlet.filters.ServletFilterConfig;
import electric.servlet.httpget.HTTPGetServlet;
import electric.servlet.sessions.HTTPSession;
import electric.session.SessionReaper;
import electric.util.Enumerations;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.file.FileUtil;
import electric.util.http.IHTTPConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMETypes;
import electric.util.product.Product;
import electric.util.product.ProductInfo;
import electric.util.sorting.BubbleSort;
import electric.util.string.Strings;
import electric.util.thread.Tasks;
import electric.webserver.WebServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class HTTPContext
implements ServletContext,
IServletConstants,
IHTTPConstants,
IGLUELoggingConstants {
    private static final ConfigComparator configComparator = new ConfigComparator();
    private static long REAP_CYCLE = 60000L;
    private static String defaultRealm;
    private static String defaultAuthMethod;
    private static final Enumeration NO_GUARDS;
    private String path;
    private String docBase;
    private Vector configs = new Vector();
    private Hashtable attributes = new Hashtable();
    private Hashtable initParameters = new Hashtable();
    private Hashtable mimeTypes = new Hashtable();
    private ClassLoader loader;
    private ServletEngine servletEngine;
    private String servletContextName;
    private Hashtable idToSession = new Hashtable();
    private Hashtable exceptionTypes = new Hashtable();
    private Hashtable errorCodes = new Hashtable();
    private IPathGuards defaultPathGuards = new PathGuards();
    private IPathGuards[] subsequentPathGuards = new IPathGuards[0];
    private HTTPGetServlet httpGet = new HTTPGetServlet();
    private IRealm realm;
    public IHTTPAuthenticator authenticator = new BasicAuthenticator();
    private HTTPContextListeners contextListeners = new HTTPContextListeners(this);
    private ServletMapper servletMapper = new ServletMapper();
    private FilterMapper filterMapper = new FilterMapper();
    private IHTTPAuthorizer authorizer = new ServletAuthorizer(this);
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public HTTPContext(String docBase) {
        this(docBase, new PathGuards());
    }

    public HTTPContext(String docBase, IPathGuards pathGuards) {
        this.docBase = HTTPContext.normalizeSlashes(docBase);
        if (docBase != null) {
            try {
                this.initLoader();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        this.defaultPathGuards = pathGuards;
        this.setDocBase(docBase);
        this.startSessionReaper();
        if (defaultAuthMethod != null) {
            this.setAuthMethod(defaultAuthMethod);
        }
        if (defaultRealm != null) {
            if (Realms.getRealm(defaultRealm) == null) {
                if (Log.isLogging(ILoggingConstants.SECURITY_EVENT)) {
                    Log.log(ILoggingConstants.SECURITY_EVENT, (Object)("Could not access default realm, services on " + this.path + " may be inaccessible."));
                }
            } else {
                this.setRealm(Realms.getRealm(defaultRealm));
            }
        }
    }

    public String toString() {
        return "Context( path=" + this.path + ", docBase=" + this.docBase + ")";
    }

    public void addConfig(Config config) {
        config.setContext(this);
        this.configs.addElement(config);
    }

    public void addConfig(String urlPattern, Config config) {
        this.addConfig(config);
        this.addServletMapping(config.getServletName(), urlPattern);
    }

    public synchronized Config getConfigWithServletName(String servletName) {
        Enumeration enumeration = this.configs.elements();
        while (enumeration.hasMoreElements()) {
            Config config = (Config)enumeration.nextElement();
            if (!config.getServletName().equals(servletName)) continue;
            return config;
        }
        return null;
    }

    public synchronized void removeConfig(Config config) {
        if (config != null) {
            this.configs.remove(config);
            this.servletMapper.removeAllMappings(config);
        }
    }

    public Vector getConfigs() {
        return this.configs;
    }

    public Config[] getSortedConfigs() {
        Object[] sortedConfigs = new Config[this.configs.size()];
        int index = 0;
        Enumeration enumeration = this.configs.elements();
        while (enumeration.hasMoreElements()) {
            sortedConfigs[index++] = (Config)enumeration.nextElement();
        }
        BubbleSort.sort(sortedConfigs, configComparator);
        return sortedConfigs;
    }

    public String[] getServletMappings(String servletName) {
        Config servletConfig = this.getConfigWithServletName(servletName);
        if (servletConfig == null) {
            return null;
        }
        return this.servletMapper.getServletMappings(servletConfig);
    }

    public void addServletMapping(String servletName, String urlPattern) {
        Config servletConfig = this.getConfigWithServletName(servletName);
        if (servletConfig == null) {
            return;
        }
        this.servletMapper.addServletMapping(servletConfig, urlPattern);
    }

    public void removeServletMapping(String servletName, String urlPattern) {
        Config servletConfig = this.getConfigWithServletName(servletName);
        if (servletConfig == null) {
            return;
        }
        this.servletMapper.removeServletMapping(servletConfig, urlPattern);
    }

    public ServletEngine getServletEngine() {
        return this.servletEngine;
    }

    public void setServletEngine(ServletEngine servletEngine) {
        this.servletEngine = servletEngine;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public Hashtable getServletMappings() {
        return this.servletMapper.getServletMappings();
    }

    public Config getServletMapping(String urlPattern) {
        return this.servletMapper.getServletMapping(urlPattern);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if ((path = HTTPContext.normalizeSlashes(path)).equals("/")) {
            path = "";
        }
        if (path.length() > 0 && !path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/") && !path.equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.path = path;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String docBase) {
        this.docBase = HTTPContext.normalizeSlashes(docBase);
        if (docBase != null && this.servletMapper.mapPathToServlet("/") == null) {
            this.addConfig("/", new Config("http-get", (Servlet)this.httpGet));
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void removeAttribute(String name) {
        if (name == null) {
            return;
        }
        Object prevValue = this.attributes.remove(name);
        this.contextListeners.notifyAttributeRemoved(name, prevValue);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            this.removeAttribute(name);
        }
        Object prevValue = this.attributes.get(name);
        this.attributes.put(name, value);
        if (prevValue != null) {
            this.contextListeners.notifyAttributeReplaced(name, prevValue);
        } else {
            this.contextListeners.notifyAttributeAdded(name, value);
        }
    }

    public String getInitParameter(String name) {
        return (String)this.initParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public void removeInitParameter(String name) {
        this.initParameters.remove(name);
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 2;
    }

    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public void log(String message) {
        Log.log(IGLUELoggingConstants.SERVLET_EVENT, (Object)message);
    }

    public void log(String message, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Log.log(IGLUELoggingConstants.SERVLET_EVENT, (Object)(message + " - " + stringWriter.toString()));
    }

    public synchronized RequestDispatcher getNamedDispatcher(String name) {
        ServletRequestDispatcher dispatcher = null;
        Enumeration enumeration = this.configs.elements();
        while (enumeration.hasMoreElements()) {
            Config config = (Config)enumeration.nextElement();
            if (!config.getServletName().equals(name)) continue;
            MappedServlet mappedServlet = new MappedServlet(config, null, null);
            dispatcher = new ServletRequestDispatcher(mappedServlet, null, true);
            break;
        }
        return dispatcher;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        MappedServlet mappedServlet;
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path must begin with a slash:" + path);
        }
        String queryString = null;
        int questionPos = path.indexOf("?");
        if (questionPos != -1) {
            queryString = path.substring(questionPos + 1);
            path = path.substring(0, questionPos);
        }
        if ((mappedServlet = this.servletMapper.mapPathToServlet(path = HTTPContext.normalizeSlashes(path))) == null) {
            return null;
        }
        return new ServletRequestDispatcher(mappedServlet, queryString);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (!XURL.hasProtocol(path)) {
            return FileUtil.getURL(new File(path));
        }
        return new URL(path);
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(this.getRealPath(path)).openStream();
        }
        catch (IOException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            return null;
        }
    }

    public Set getResourcePaths(String url) {
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException("url " + url + " does not start with a slash");
        }
        String resourcePath = this.getRealPath(url);
        if (resourcePath == null) {
            return null;
        }
        HashSet<String> paths = new HashSet<String>();
        File file = new File(resourcePath);
        if (file.isDirectory()) {
            String[] resources = file.list();
            int i = 0;
            while (i < resources.length) {
                paths.add(resources[i]);
                ++i;
            }
        } else {
            paths.add(url);
        }
        return paths;
    }

    public ServletContext getContext(String path) {
        return this.servletEngine.getContext(path);
    }

    public String getRealPath(String path) {
        return this.docBase == null ? null : Strings.splice(this.docBase, HTTPContext.normalizeSlashes(path));
    }

    public String getServerInfo() {
        ProductInfo productInfo = Product.getProductConfig().getProductInfo();
        return "GLUE/" + productInfo.getMajorVersion() + "." + productInfo.getMinorVersion();
    }

    public void addMimeType(String extension, String mimeType) {
        this.mimeTypes.put(extension, mimeType);
    }

    public void removeMimeType(String extension) {
        this.mimeTypes.remove(extension);
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        String extension = Strings.extension(file);
        if (extension == null) {
            return null;
        }
        String mimeType = (String)this.mimeTypes.get(extension);
        return mimeType != null ? mimeType : MIMETypes.getMimeType(extension);
    }

    public Hashtable getMimeTypes() {
        return this.mimeTypes;
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServletNames() {
        return null;
    }

    public Enumeration getServlets() {
        return null;
    }

    public void startup() throws ServletException {
        Config[] sortedConfigs = this.getSortedConfigs();
        int i = 0;
        while (i < sortedConfigs.length) {
            sortedConfigs[i].startup();
            ++i;
        }
        this.contextListeners.notifyStartup();
    }

    public void shutdown() {
        Enumeration enumeration = this.configs.elements();
        while (enumeration.hasMoreElements()) {
            ((Config)enumeration.nextElement()).shutdown();
        }
        this.contextListeners.notifyShutdown();
    }

    private void initLoader() throws IOException {
        if (this.loader != null) {
            return;
        }
        File webInfDir = new File(this.docBase + File.separatorChar + "WEB-INF");
        if (!webInfDir.exists()) {
            return;
        }
        this.prepareTmpDirectory(webInfDir);
        URL[] urls = this.getResourceURLs(webInfDir);
        try {
            Class<?> loaderClass = Class.forName("java.net.URLClassLoader");
            Constructor<?> constructor = loaderClass.getConstructor(urls.getClass(), class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = HTTPContext.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            this.loader = (ClassLoader)constructor.newInstance(urls, this.getClass().getClassLoader());
        }
        catch (Exception exception) {}
    }

    private void prepareTmpDirectory(File webInfDir) {
        File tmpFile = new File(webInfDir, "tmp");
        if (!tmpFile.exists()) {
            tmpFile.mkdir();
        }
        this.setAttribute("javax.servlet.context.tempdir", tmpFile);
    }

    private URL[] getResourceURLs(File webInfDir) throws MalformedURLException {
        File libDir;
        Vector<URL> vector = new Vector<URL>();
        File classDir = new File(webInfDir, "classes");
        if (classDir.exists()) {
            vector.addElement(FileUtil.getURL(classDir));
        }
        if ((libDir = new File(webInfDir, "lib")).exists()) {
            File[] files = FileUtil.listFiles(libDir);
            int i = 0;
            while (i < files.length) {
                String name = files[i].getName();
                if (name.endsWith(".jar") || name.endsWith(".zip")) {
                    vector.addElement(FileUtil.getURL(files[i]));
                }
                ++i;
            }
        }
        Object[] urls = new URL[vector.size()];
        vector.copyInto(urls);
        return urls;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return ClassLoaders.loadClass(name, this.loader);
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    private static String normalizeSlashes(String path) {
        return path == null ? path : path.replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String absolutePath, ServletRequest request, ServletResponse response) throws ServletException, IOException {
        InboundHTTPRequest httpRequest = (InboundHTTPRequest)request;
        OutboundHTTPResponse httpResponse = (OutboundHTTPResponse)response;
        String relativePath = absolutePath.substring(this.getPath().length());
        MappedServlet mapping = this.servletMapper.mapPathToServlet(relativePath);
        if (mapping == null || mapping.config == null) {
            httpResponse.sendError(404, "cannot find " + absolutePath);
            return;
        }
        ServletFilterChain filterChain = this.filterMapper.mapPathToFilters(mapping.config, relativePath);
        if (!this.authorizer.authorize(httpRequest, httpResponse, relativePath)) {
            return;
        }
        httpRequest.setPathInfo(mapping.pathInfo);
        httpRequest.setServletPath(mapping.servletPath);
        httpRequest.setConfig(mapping.config);
        httpRequest.getSession(false);
        try {
            String location;
            ClassLoader previousLoader = ClassLoaders.getContextClassLoader();
            ClassLoaders.setContextClassLoader(this.getClassLoader());
            try {
                if (filterChain == null) {
                    mapping.config.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                } else {
                    filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                ClassLoaders.setContextClassLoader(previousLoader);
                throw throwable;
            }
            ClassLoaders.setContextClassLoader(previousLoader);
            if (httpResponse.getStatus() != 200 && (location = this.getErrorPage(httpResponse.getStatus())) != null) {
                httpResponse.sendRedirect(Strings.splice(this.getPath(), location));
            }
        }
        catch (ServletException exception) {
            String location = this.getErrorPage(((Object)((Object)exception)).getClass().getName());
            if (location != null) {
                httpResponse.sendRedirect(Strings.splice(this.getPath(), location));
            }
            throw exception;
        }
    }

    public WebServer getWebServer() {
        return this.servletEngine.getWebServer();
    }

    public HTTPSession getSession(String id) {
        return (HTTPSession)this.idToSession.get(id);
    }

    public HTTPSession removeSession(String id) {
        return (HTTPSession)this.idToSession.remove(id);
    }

    public HTTPSession newSession() {
        HTTPSession session = new HTTPSession(this);
        this.idToSession.put(session.getId(), session);
        return session;
    }

    public static void setReapCycle(long reapCycle) {
        REAP_CYCLE = reapCycle;
    }

    public static long getReapCycle() {
        return REAP_CYCLE;
    }

    private void startSessionReaper() {
        SessionReaper reaper = new SessionReaper(this.idToSession);
        Tasks.getShared().runAfter(reaper, REAP_CYCLE, "session reaper", REAP_CYCLE, false);
    }

    public void addWelcomeFile(String filename) {
        this.httpGet.addWelcomeFile(filename);
    }

    public void removeWelcomeFile(String filename) {
        this.httpGet.removeWelcomeFile(filename);
    }

    public void addErrorPage(String exceptionType, String location) {
        this.exceptionTypes.put(exceptionType, location);
    }

    public String getErrorPage(String exceptionType) {
        return (String)this.exceptionTypes.get(exceptionType);
    }

    public void addErrorPage(int errorCode, String location) {
        this.errorCodes.put(new Integer(errorCode), location);
    }

    public String getErrorPage(int errorCode) {
        return (String)this.errorCodes.get(new Integer(errorCode));
    }

    public void setRealm(IRealm realm) {
        this.realm = realm;
    }

    public IRealm getRealm() {
        return this.realm;
    }

    public static void setDefaultAuthMethod(String method) {
        defaultAuthMethod = method;
    }

    public static String getDefaultAuthMethod() {
        return defaultAuthMethod;
    }

    public String getAuthMethod() {
        if (this.authenticator != null) {
            return this.authenticator.getAuthMethod();
        }
        return null;
    }

    public void setAuthMethod(String authMethod) {
        authMethod = authMethod.trim();
        if (this.authenticator != null && this.authenticator.getAuthMethod().equals(authMethod)) {
            return;
        }
        this.authenticator = "DIGEST".equalsIgnoreCase(authMethod) ? new DigestAuthenticator() : ("BASIC".equalsIgnoreCase(authMethod) ? new BasicAuthenticator() : null);
    }

    public IHTTPAuthorizer getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(IHTTPAuthorizer authorizer) {
        this.authorizer = authorizer;
    }

    public synchronized Enumeration getGuards(String path) {
        Enumeration enumeration = this.defaultPathGuards.getGuards(path);
        int i = 0;
        while (i < this.subsequentPathGuards.length) {
            enumeration = new Enumerations(enumeration, this.subsequentPathGuards[i].getGuards(path));
            ++i;
        }
        return enumeration;
    }

    private boolean noGuards() {
        if (!this.defaultPathGuards.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < this.subsequentPathGuards.length) {
            if (!this.subsequentPathGuards[i].isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized Enumeration getAllGuards(String path) {
        if (this.noGuards() || path.endsWith(".wsdl")) {
            return NO_GUARDS;
        }
        Vector guards = null;
        StringBuffer subpath = new StringBuffer();
        int i = 0;
        while (i < path.length()) {
            char ch = path.charAt(i);
            if (ch == '/' && i > 0) {
                guards = this.addGuards(guards, subpath.toString());
            }
            subpath.append(ch);
            if (ch == '/' || i == path.length() - 1) {
                guards = this.addGuards(guards, subpath.toString());
            }
            ++i;
        }
        return guards == null ? NO_GUARDS : guards.elements();
    }

    private Vector addGuards(Vector guards, String uri) {
        Enumeration enumeration = this.getGuards(uri);
        if (enumeration.hasMoreElements()) {
            if (guards == null) {
                guards = new Vector();
            }
            while (enumeration.hasMoreElements()) {
                guards.addElement(enumeration.nextElement());
            }
        }
        return guards;
    }

    public synchronized void addGuard(String path) {
        this.addGuard(path, new Authenticate());
    }

    public synchronized void addGuard(String path, IGuard guard) {
        this.defaultPathGuards.addGuard(path, guard);
    }

    public void addPathGuards(IPathGuards pathGuards) {
        this.subsequentPathGuards = (IPathGuards[])ArrayUtil.addElement(this.subsequentPathGuards, pathGuards);
    }

    public static String getDefaultRealmName() {
        return defaultRealm;
    }

    public static void setDefaultRealm(String name) {
        defaultRealm = name;
    }

    public synchronized void addListener(String listenerClassName) {
        this.contextListeners.addListener(listenerClassName);
    }

    public void addFilterConfig(ServletFilterConfig config) {
        this.filterMapper.addFilterConfig(config);
    }

    public void addFilterMapping(String filterName, String servletName, String urlPattern) {
        this.filterMapper.addFilterMapping(filterName, servletName, urlPattern);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NO_GUARDS = new Vector().elements();
    }
}

