/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet;

import electric.servlet.HTTPContext;
import electric.util.classloader.ClassLoaders;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class Config
implements ServletConfig {
    private String name;
    private Hashtable parameters = new Hashtable();
    private String className;
    private HTTPContext context;
    private int startupOrder = Integer.MAX_VALUE;
    private boolean initialized = false;
    private Servlet servlet;

    public Config(String name, String className) {
        this.name = name;
        this.className = className;
    }

    public Config(String name, Servlet servlet) {
        this.name = name;
        this.servlet = servlet;
        this.className = servlet.getClass().getName();
    }

    public String toString() {
        return "Config( name=" + this.name + ", classname=" + this.className + ", parameters=" + this.parameters + " )";
    }

    public int getLoadOnStartup() {
        return this.startupOrder;
    }

    public void setLoadOnStartup(int startupOrder) {
        this.startupOrder = startupOrder;
    }

    public String getClassName() {
        return this.className;
    }

    public HTTPContext getContext() {
        return this.context;
    }

    public void setContext(HTTPContext context) {
        this.context = context;
    }

    public Hashtable getInitParameters() {
        return this.parameters;
    }

    public String getInitParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.parameters.keys();
    }

    public void addInitParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public void removeInitParameter(String key) {
        this.parameters.remove(key);
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getServletName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Servlet getServlet() throws ServletException {
        if (this.servlet == null) {
            this.servlet = this.newServlet();
        }
        if (!this.initialized) {
            ClassLoader previousLoader = ClassLoaders.getContextClassLoader();
            ClassLoaders.setContextClassLoader(this.context.getClassLoader());
            try {
                this.servlet.init((ServletConfig)this);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ClassLoaders.setContextClassLoader(previousLoader);
                throw throwable;
            }
            ClassLoaders.setContextClassLoader(previousLoader);
            this.initialized = true;
        }
        return this.servlet;
    }

    private Servlet newServlet() throws ServletException {
        try {
            return (Servlet)this.context.loadClass(this.className).newInstance();
        }
        catch (Exception exception) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("unable to find servlet class. ");
            buffer.append("make sure it is available in either WEB-INF\\classes or WEB-INF\\lib directories\n");
            buffer.append(exception.toString());
            throw new ServletException(buffer.toString());
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.getServlet().service(request, response);
    }

    public synchronized void startup() throws ServletException {
        if (this.startupOrder != -1) {
            this.getServlet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.servlet == null) {
            return;
        }
        try {
            ClassLoader previousLoader = ClassLoaders.getContextClassLoader();
            ClassLoaders.setContextClassLoader(this.context.getClassLoader());
            try {
                this.servlet.destroy();
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ClassLoaders.setContextClassLoader(previousLoader);
                throw throwable;
            }
            ClassLoaders.setContextClassLoader(previousLoader);
            {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.servlet = null;
        this.initialized = false;
    }
}

