/*
 * Decompiled with CFR 0.152.
 */
package electric.service.virtual;

import electric.glue.IGLUELoggingConstants;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.service.IService;
import electric.service.reference.ReferenceFactories;
import electric.util.Context;
import electric.util.Value;
import electric.util.XURL;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.Product;
import electric.util.reflect.MethodLookup;
import electric.util.reflect.Reflect;
import electric.wsdl.WSDL;
import electric.wsdl.generator.WSDLGenerator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class VirtualService
implements IService,
IReference,
IGLUELoggingConstants {
    private static boolean enabled;
    private static boolean allowEnable;
    private Class[] types;
    private InvocationHandler handler;
    private WSDL wsdl;
    private Context context = new Context();
    private IReference referenceChain;

    public VirtualService(Class type, InvocationHandler handler) {
        this(new Class[]{type}, handler);
    }

    public VirtualService(Class[] types, InvocationHandler handler) {
        this.checkEnabled();
        this.types = types;
        this.handler = handler;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("VirtualService( ");
        int i = 0;
        while (i < this.types.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.types[i]);
            ++i;
        }
        buffer.append(" )");
        return buffer.toString();
    }

    public synchronized Context getContext() {
        return this.context;
    }

    public synchronized void setContext(Context context) {
        this.context = context;
    }

    public Value invoke(Method method, Object[] args, Context context) throws Throwable {
        this.checkEnabled();
        Object result = this.handler.invoke(this, method, args);
        return new Value(result, method.getReturnType());
    }

    public Value invoke(String methodName, Object[] args, Class[] argTypes, Context context) throws Throwable {
        this.checkEnabled();
        int i = 0;
        while (i < this.types.length) {
            try {
                Method method = MethodLookup.getMethod(this.types[i], methodName, argTypes);
                return this.invoke(method, args, context);
            }
            catch (NoSuchMethodException exception) {
                ++i;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public Value invoke(String methodName, String[] args, Context context) throws Throwable {
        this.checkEnabled();
        int i = 0;
        while (i < this.types.length) {
            try {
                Method method = MethodLookup.getMethod(this.types[i], methodName, args.length);
                Class<?>[] types = method.getParameterTypes();
                Object[] objectArgs = new Object[args.length];
                int j = 0;
                while (j < args.length) {
                    objectArgs[j] = Reflect.valueOf(args[j], types[j]);
                    ++j;
                }
                return this.invoke(method, objectArgs, context);
            }
            catch (NoSuchMethodException exception) {
                ++i;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public IReference getReference() {
        if (this.referenceChain == null) {
            this.referenceChain = ReferenceFactories.getReferenceChain(this, this);
        }
        return this.referenceChain;
    }

    public WSDL getWSDL() {
        if (this.wsdl != null) {
            return this.wsdl;
        }
        try {
            String urn = Registry.getPath("/", (Object)this);
            String[] urls = Registry.getAllPaths(this);
            if (urls.length == 0) {
                urls = new String[]{urn};
            }
            XURL[] endpoints = new XURL[urls.length];
            int i = 0;
            while (i < endpoints.length) {
                endpoints[i] = new XURL(urls[i]);
                ++i;
            }
            this.wsdl = WSDLGenerator.getWSDL(endpoints, "virtual service", this.context, null, this.types);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.wsdl;
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("Virtual Service cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
        if (!enabled && Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"virtual service feature cannot be enabled");
        }
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"Virtual Service feature disabled");
    }

    private void checkEnabled() {
        if (!enabled) {
            throw new IllegalStateException("VirtualService is disabled");
        }
    }

    static {
        allowEnable = true;
        Product.startup();
    }
}

