/*
 * Decompiled with CFR 0.152.
 */
package electric.service.instrumentation;

import electric.util.Context;

public class MethodInstrumentationInfo {
    private int executionCounter = 0;
    private long fastest = Long.MAX_VALUE;
    private long slowest = Long.MIN_VALUE;
    private long last;
    private long average;

    void startTiming() {
        Context.thread().setProperty("execStarted", new Long(System.currentTimeMillis()));
    }

    void stopTiming() {
        long execEnded = System.currentTimeMillis();
        long execStarted = (Long)Context.thread().getProperty("execStarted");
        this.last = execEnded - execStarted;
        this.fastest = Math.min(this.fastest, this.last);
        this.slowest = Math.max(this.slowest, this.last);
        ++this.executionCounter;
        this.average = (this.average * (long)(this.executionCounter - 1) + this.last) / (long)this.executionCounter;
    }

    long getFastest() {
        return this.fastest;
    }

    long getSlowest() {
        return this.slowest;
    }

    long getLast() {
        return this.last;
    }

    long getAverage() {
        return this.average;
    }

    long getTotal() {
        return this.executionCounter;
    }

    long getExecutionsPerUnitOfTime(int unitoftime) {
        throw new RuntimeException("TBD");
    }
}

