/*
 * Decompiled with CFR 0.152.
 */
package electric.service.descriptor;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.service.descriptor.IInitializer;
import electric.service.descriptor.MethodDescriptor;
import electric.service.descriptor.initializer.Constructor;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.constructor.Factory;
import electric.util.constructor.IInstantiator;
import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.File;
import java.io.IOException;

public final class ServiceDescriptor
implements IGLUELoggingConstants,
IGLUEContextConstants {
    private static final String XML_EXTENSION = ".xml";
    private static final String DEFAULT_DESCRIPTION = "No Description";
    private static final float DEFAULT_PRIORITY = 5.0f;
    private static IInitializer[] handlers = new IInitializer[]{new Constructor()};
    public String activation;
    public String dataDirectory;
    public String description;
    public String endpoint;
    public String namespace;
    public String soapAction;
    public float priority = 5.0f;
    public String style;
    public String use;
    public String version;
    public String targetNamespace;
    public String[] xmlInclude = new String[0];
    public String[] inboundSoapRequestInterceptor = new String[0];
    public String[] outboundSoapResponseInterceptor = new String[0];
    public String[] intf = new String[0];
    public MethodDescriptor[] methods = new MethodDescriptor[0];
    public Element[] dataHandler = new Element[0];
    public boolean publish;
    public IInstantiator instantiator;
    public Element[] extensibilityElements = new Element[0];
    public String wsdlPersonalityClassName;
    public String soapPersonalityClassName;
    private transient Context context = new Context();
    private transient Object serviceObject = null;
    private transient boolean classLoaderSet = false;

    public ServiceDescriptor() {
    }

    public ServiceDescriptor(Document document) throws ParseException {
        this.readDescriptor(new Document(document));
    }

    public ServiceDescriptor(String className, String[] interfaces, String methodName, String[] args) {
        this.instantiator = methodName == null ? new electric.util.constructor.Constructor(className, args) : new Factory(className, methodName, args);
        this.intf = interfaces;
    }

    public ServiceDescriptor(File file) throws ParseException {
        this.readDescriptor(file);
    }

    public boolean isFactory() {
        return this.instantiator instanceof Factory;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() throws Throwable {
        if (!this.classLoaderSet) {
            this.setClassLoader(null);
        }
        return this.context;
    }

    public Document getDocument() {
        Document document = new Document();
        Element root = document.addElement("service");
        this.writeDefaults(root);
        int i = 0;
        while (i < this.extensibilityElements.length) {
            root.addElement(this.extensibilityElements[i]);
            ++i;
        }
        return document;
    }

    public Element[] getExtensibilityElements() {
        return this.extensibilityElements;
    }

    public Element getExtensibilityElement(String name) {
        int i = 0;
        while (i < this.extensibilityElements.length) {
            if (this.extensibilityElements[i].getName().equals(name)) {
                return this.extensibilityElements[i];
            }
            ++i;
        }
        return null;
    }

    public Element[] getExtensibilityElements(String name) {
        Element[] retVal = new Element[]{};
        int i = 0;
        while (i < this.extensibilityElements.length) {
            if (this.extensibilityElements[i].getName().equals(name)) {
                retVal = (Element[])ArrayUtil.addElement(retVal, this.extensibilityElements[i]);
            }
            ++i;
        }
        return retVal;
    }

    public void addExtensibilityElement(Element element) {
        this.extensibilityElements = (Element[])ArrayUtil.addElement(this.extensibilityElements, element);
    }

    private void readDescriptor(File file) throws ParseException {
        this.readDescriptor(new Document(file));
    }

    private void readDescriptor(Document document) {
        Element root = document.getRoot();
        this.setDefaults(root);
    }

    public static File create(String className, String[] interfaces, String methodName, String filePath, String publishPath) throws IOException {
        ServiceDescriptor descriptor = new ServiceDescriptor(className, interfaces, methodName, new String[0]);
        return ServiceDescriptor.save(filePath, descriptor.getDocument(), publishPath);
    }

    public static File save(String path, Document descriptor, String publishName) throws IOException {
        if (!publishName.toLowerCase().endsWith(XML_EXTENSION)) {
            publishName = publishName + XML_EXTENSION;
        }
        File file = new File(path, publishName);
        new File(file.getParent()).mkdirs();
        descriptor.write(file);
        return file;
    }

    public void setClassLoader(ClassLoader classLoader) throws Throwable {
        this.classLoaderSet = true;
        int i = 0;
        while (i < handlers.length) {
            handlers[i].create(this, classLoader);
            ++i;
        }
    }

    public Object getObject() throws Throwable {
        if (!this.classLoaderSet) {
            this.setClassLoader(null);
        }
        return this.serviceObject;
    }

    public void setObject(Object serviceObject) {
        this.serviceObject = serviceObject;
    }

    public static void addInitializer(IInitializer handler) {
        handlers = (IInitializer[])ArrayUtil.addElement(handlers, handler);
    }

    private void setDefaults(Element descriptor) {
        Element element = descriptor.removeElement("activation");
        this.activation = element == null ? null : element.getString();
        element = descriptor.removeElement("dataDirectory");
        this.dataDirectory = element == null ? null : element.getString();
        element = descriptor.removeElement("description");
        this.description = element == null ? DEFAULT_DESCRIPTION : element.getString();
        this.dataHandler = this.getValues("dataHandler", descriptor);
        element = descriptor.removeElement("endpoint");
        this.endpoint = element == null ? null : element.getString();
        this.inboundSoapRequestInterceptor = this.getStringValues("inboundSoapRequestInterceptor", descriptor);
        this.intf = this.getStringValues("interface", descriptor);
        this.methods = this.getMethodDescriptors(descriptor);
        this.outboundSoapResponseInterceptor = this.getStringValues("outboundSoapResponseInterceptor", descriptor);
        element = descriptor.removeElement("namespace");
        this.namespace = element == null ? null : element.getString();
        element = descriptor.removeElement("publish");
        this.publish = element == null ? true : Strings.getBoolean(element.getString(), true);
        element = descriptor.removeElement("soapAction");
        this.soapAction = element == null ? null : element.getString();
        element = descriptor.removeElement("priority");
        this.priority = element == null ? 5.0f : element.getFloat();
        element = descriptor.removeElement("style");
        this.style = element == null ? null : element.getString().toLowerCase();
        element = descriptor.removeElement("use");
        this.use = element == null ? null : element.getString();
        element = descriptor.removeElement("wsdlPersonality");
        this.wsdlPersonalityClassName = element == null ? null : element.getString();
        element = descriptor.removeElement("soapPersonality");
        this.soapPersonalityClassName = element == null ? null : element.getString();
        element = descriptor.removeElement("targetNamespace");
        this.targetNamespace = element == null ? null : element.getString();
        this.xmlInclude = this.getStringValues("xmlInclude", descriptor);
        Element constructor = descriptor.removeElement("constructor");
        this.instantiator = constructor != null ? new electric.util.constructor.Constructor(constructor) : new Factory(descriptor.removeElement("factory"));
        Elements elems = descriptor.getElements();
        while (elems.hasMoreElements()) {
            this.addExtensibilityElement(elems.next());
        }
    }

    private void writeDefaults(Element root) {
        this.instantiator.writeDescriptor(root);
        this.writeElement(root, "activation", this.activation);
        this.writeElement(root, "dataDirectory", this.dataDirectory);
        this.writeElement(root, "description", this.description);
        this.writeElement(root, "endpoint", this.endpoint);
        this.writeElement(root, "namespace", this.namespace);
        this.writeElement(root, "publish", "" + this.publish);
        this.writeElement(root, "soapAction", this.soapAction);
        this.writeElement(root, "priority", Float.toString(this.priority));
        this.writeElement(root, "style", this.style);
        this.writeElement(root, "use", this.use);
        this.writeElement(root, "wsdlPersonality", this.wsdlPersonalityClassName);
        this.writeElement(root, "soapPersonality", this.soapPersonalityClassName);
        this.writeElement(root, "targetNamespace", this.targetNamespace);
        this.writeElements(root, "xmlInclude", this.xmlInclude);
        this.writeElements(root, "outboundSoapResponseInterceptor", this.outboundSoapResponseInterceptor);
        this.writeElements(root, "inboundSoapRequestInterceptor", this.inboundSoapRequestInterceptor);
        this.writeElements(root, "interface", this.intf);
        this.writeMethods(root);
        if (this.dataHandler != null) {
            int i = 0;
            while (i < this.dataHandler.length) {
                root.addElement(this.dataHandler[i]);
                ++i;
            }
        }
    }

    private void writeElement(Element root, String name, String value) {
        if (value != null) {
            root.addElement(name).setText(value);
        }
    }

    private void writeElements(Element root, String name, String[] value) {
        if (value != null) {
            int i = 0;
            while (i < value.length) {
                root.addElement(name).setText(value[i]);
                ++i;
            }
        }
    }

    private Element[] getValues(String name, Element element) {
        Elements elems = element.removeElements(name);
        Element[] retVal = new Element[]{};
        while (elems.hasMoreElements()) {
            retVal = (Element[])ArrayUtil.addElement(retVal, elems.next());
        }
        return retVal;
    }

    private String[] getStringValues(String name, Element element) {
        Elements elements = element.removeElements(name);
        String[] retVal = new String[]{};
        while (elements.hasMoreElements()) {
            String value = elements.next().getString();
            if (value == null || value.equals("")) continue;
            retVal = (String[])ArrayUtil.addElement(retVal, value);
        }
        return retVal;
    }

    private MethodDescriptor[] getMethodDescriptors(Element element) {
        Elements elements = element.removeElements("method");
        MethodDescriptor[] descriptors = new MethodDescriptor[]{};
        while (elements.hasMoreElements()) {
            MethodDescriptor descriptor = new MethodDescriptor(elements.next());
            descriptors = (MethodDescriptor[])ArrayUtil.addElement(descriptors, descriptor);
        }
        return descriptors;
    }

    private void writeMethods(Element root) {
        int i = 0;
        while (i < this.methods.length) {
            this.writeMethod(root, this.methods[i]);
            ++i;
        }
    }

    private void writeMethod(Element root, MethodDescriptor methodDescriptor) {
        methodDescriptor.writeMethod(root);
    }
}

