/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms;

import electric.server.jms.IJMSAdapter;
import electric.server.jms.IJMSConstants;
import electric.util.Context;
import electric.util.jms.JMSUtil;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;

public class BasicJNDIAdapter
implements IJMSAdapter,
IJMSConstants {
    private Hashtable jndiProps;

    public void startup(Context context) throws JMSException, NamingException {
        this.jndiProps = (Hashtable)Context.getProperty(context, "jndiProperties");
        if (this.jndiProps == null) {
            throw new JMSException("default JMS adapter is missing JNDI properties");
        }
    }

    public boolean isStarted() {
        return this.jndiProps != null;
    }

    public void shutdown() throws JMSException, NamingException {
        this.jndiProps = null;
    }

    public Context getStartupContext() {
        if (!this.isStarted()) {
            throw new IllegalStateException("adapter is not started, unable to gather startup context information");
        }
        Context context = new Context();
        context.setProperty("jndiProperties", this.jndiProps);
        return context;
    }

    public Queue getQueue(String queueName, boolean create) throws JMSException, NamingException {
        return JMSUtil.lookupQ(queueName, this.jndiProps);
    }

    public QueueConnectionFactory getQueueConnectionFactory(String queueConnFactoryName, boolean create) throws JMSException, NamingException {
        return JMSUtil.lookupQConnFactory(queueConnFactoryName, this.jndiProps);
    }

    public String getClassName() {
        return "electric.server.jms.BasicJNDIAdapter";
    }

    public String getProviderName() {
        return "default unspecified";
    }
}

