/*
 * Decompiled with CFR 0.152.
 */
package electric.server.http;

import electric.glue.IGLUEContextConstants;
import electric.glue.pro.config.ConsoleConfig;
import electric.http.HTTPMessage;
import electric.net.socket.SocketServer;
import electric.security.IRealm;
import electric.server.http.IHTTPListener;
import electric.servlet.Config;
import electric.servlet.HTTPContext;
import electric.servlet.sessions.HTTPSession;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.http.HTTPUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.Product;
import electric.util.thread.ThreadPool;
import electric.webserver.WebServer;
import electric.webserver.WebServers;
import java.io.IOException;
import java.net.MalformedURLException;

public final class HTTP
implements IGLUEContextConstants,
ILoggingConstants {
    private static final long WARNING_EVENT = Log.getCode("WARNING");
    private static final String ELECTRIC_HTTP_URL = "electric.http.url";
    private static IHTTPListener[] listeners = new IHTTPListener[0];
    static /* synthetic */ Class class$electric$server$http$ServletServer;

    public static synchronized void addListener(IHTTPListener listener) {
        listeners = (IHTTPListener[])ArrayUtil.addElement(listeners, listener);
    }

    public static HTTPContext startup(String url, Context context) throws IOException {
        Product.startupAsServer();
        String registryRoot = context.getStringProperty("registryRoot");
        String docBase = context.getStringProperty("docBase");
        String servletName = context.getStringProperty("servletName");
        IRealm realm = (IRealm)context.getProperty("realm");
        String authMethod = context.getStringProperty("authMethod");
        WebServer webServer = WebServers.startWebServer(url);
        XURL xurl = HTTP.getServerXURL(url, webServer.getXURL().getPort());
        String path = HTTPUtil.getContextPath(xurl);
        if (servletName == null) {
            servletName = xurl.toString();
        }
        Config glueServletConfig = new Config(servletName, (class$electric$server$http$ServletServer == null ? (class$electric$server$http$ServletServer = HTTP.class$("electric.server.http.ServletServer")) : class$electric$server$http$ServletServer).getName());
        glueServletConfig.addInitParameter(ELECTRIC_HTTP_URL, xurl.toString());
        if (registryRoot != null) {
            glueServletConfig.addInitParameter("httpRegistryRoot", registryRoot);
        }
        HTTPContext httpContext = new HTTPContext(docBase);
        httpContext.addConfig("/*", glueServletConfig);
        if (ConsoleConfig.isEnabled()) {
            httpContext.addConfig("/console/*", new Config("glue-console", "electric.console.ConsoleServlet"));
        }
        if (authMethod != null) {
            httpContext.setAuthMethod(authMethod);
        }
        if (realm != null) {
            httpContext.setRealm(realm);
        }
        try {
            webServer.addContext(path, httpContext);
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to register HTTP context with the web server", exception);
            }
            throw new IOException(exception.toString());
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].startedSOAPHTTPServer();
            ++i;
        }
        return httpContext;
    }

    public static HTTPContext startup(String url) throws IOException {
        Context context = new Context();
        context.setProperty("registryRoot", "/");
        return HTTP.startup(url, context);
    }

    public static HTTPContext startup(String url, String root) throws IOException {
        Context context = new Context();
        context.setProperty("registryRoot", root);
        return HTTP.startup(url, context);
    }

    public static void shutdown(String url) throws IOException, MalformedURLException {
        XURL xurl = new XURL(url);
        WebServer webServer = WebServers.getWebServer(xurl.getPort());
        if (webServer == null) {
            Log.log(WARNING_EVENT, (Object)("no web server is running on port " + xurl.getPort()));
            return;
        }
        XURL serverXURL = HTTP.getServerXURL(url, webServer.getXURL().getPort());
        String contextPath = HTTPUtil.getContextPath(serverXURL);
        HTTPContext servletContext = webServer.removeContext(contextPath);
        servletContext.shutdown();
        if (webServer.getAllContexts().length == 0) {
            webServer.shutdown();
        }
    }

    private static XURL getServerXURL(String url, int webServerPort) throws MalformedURLException {
        XURL xurl = new XURL(url);
        return new XURL(xurl.getProtocol(), xurl.getHost(), webServerPort, xurl.getFile(), xurl.getReference());
    }

    public static void shutdown() {
        WebServers.shutdownAllWebServers();
    }

    public static void setDefaultBacklog(int backlog) {
        SocketServer.setDefaultBacklog(backlog);
    }

    public static int getDefaultBacklog() {
        return SocketServer.getDefaultBacklog();
    }

    public static void setMaxOutboundKeepAlive(int max) {
        HTTPMessage.setMaxCacheSize(max);
    }

    public static void setMaxInboundKeepAlive(int max) {
        SocketServer.setMaxKeepAlive(max);
    }

    public static void setMaxThreads(int max) {
        ThreadPool.getShared().setMaxThreads(max);
    }

    public static void setSessionTimeout(int seconds) {
        HTTPSession.setDefaultTimeout(seconds);
    }

    public static int getSessionTimeout() {
        return HTTPSession.getDefaultTimeout();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

