/*
 * Decompiled with CFR 0.152.
 */
package electric.net.socket.ssl.providers.installed;

import electric.glue.IGLUELoggingConstants;
import electric.net.socket.ssl.ISSLProvider;
import electric.net.socket.ssl.providers.jsseri.JSSERIProvider;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class InstalledProvider
implements ISSLProvider,
IGLUELoggingConstants {
    private SSLServerSocketFactory serverFactory;
    private SSLSocketFactory clientFactory;

    public InstalledProvider() throws Exception {
        this.initialize();
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        return this.serverFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.clientFactory;
    }

    public void initialize() throws Exception {
        block12: {
            Object sslserverfactory;
            JSSERIProvider provider = null;
            try {
                sslserverfactory = SSLServerSocketFactory.getDefault();
                if (sslserverfactory instanceof SSLServerSocketFactory) {
                    this.serverFactory = (SSLServerSocketFactory)sslserverfactory;
                } else {
                    if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
                        Log.log(ILoggingConstants.STARTUP_EVENT, (Object)"installed JSSE ServerSocketFactory is not an SSLServerSocketFactory.  Defaulting to SUN Reference Implementation.");
                    }
                    provider = new JSSERIProvider();
                    this.serverFactory = provider.getSSLServerSocketFactory();
                }
            }
            catch (Exception exception) {
                if (provider == null) {
                    provider = new JSSERIProvider();
                }
                this.serverFactory = provider.getSSLServerSocketFactory();
            }
            try {
                sslserverfactory = SSLSocketFactory.getDefault();
                if (sslserverfactory instanceof SSLSocketFactory) {
                    this.clientFactory = (SSLSocketFactory)sslserverfactory;
                    break block12;
                }
                if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
                    Log.log(ILoggingConstants.STARTUP_EVENT, (Object)"installed JSSE ServerSocketFactory is not an SSLServerSocketFactory.  Defaulting to SUN Reference Implementation.");
                }
                if (provider == null) {
                    provider = new JSSERIProvider();
                }
                this.clientFactory = provider.getSSLSocketFactory();
            }
            catch (Exception exception) {
                if (provider == null) {
                    provider = new JSSERIProvider();
                }
                this.clientFactory = provider.getSSLSocketFactory();
            }
        }
    }
}

