/*
 * Decompiled with CFR 0.152.
 */
package electric.jaxm;

import electric.jaxm.DetailEntryImpl;
import electric.jaxm.DetailImpl;
import electric.jaxm.NodeImpl;
import electric.jaxm.SOAPBodyImpl;
import electric.jaxm.SOAPElementImpl;
import electric.jaxm.SOAPEnvelopeImpl;
import electric.jaxm.SOAPFaultImpl;
import electric.jaxm.SOAPHeaderElementImpl;
import electric.jaxm.SOAPHeaderImpl;
import electric.jaxm.SOAPPartImpl;
import electric.jaxm.TextImpl;
import electric.soap.ISOAPConstants;
import electric.util.mime.MIMEHeaders;
import electric.xml.CharacterData;
import electric.xml.Element;
import electric.xml.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

final class SOAPMessageImpl
extends SOAPMessage
implements ISOAPConstants {
    String description;
    electric.soap.SOAPMessage message = new electric.soap.SOAPMessage();
    MimeHeaders headers = new MimeHeaders();

    SOAPMessageImpl() {
        this.message.addEnvelope();
        this.message.addBody();
        this.message.addHeader();
    }

    SOAPMessageImpl(MimeHeaders headers, InputStream input) {
        this.headers = headers;
    }

    SOAPMessageImpl(electric.soap.SOAPMessage message) {
        this.message = message;
        MIMEHeaders mimeHeaders = message.getMIMEHeaders();
        if (mimeHeaders != null) {
            Enumeration enum1 = mimeHeaders.getHeaderNames();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                Enumeration enum2 = mimeHeaders.getHeaders(name);
                while (enum2.hasMoreElements()) {
                    this.headers.addHeader(name, (String)enum2.nextElement());
                }
            }
        }
    }

    public String toString() {
        return this.message.toString();
    }

    public String getContentDescription() {
        return this.description;
    }

    public void setContentDescription(String description) {
        this.description = description;
    }

    public SOAPPart getSOAPPart() {
        return new SOAPPartImpl(this);
    }

    public void removeAllAttachments() {
        this.message.removeAttachments();
    }

    public int countAttachments() {
        return this.message.hasAttachments() ? this.message.getAttachments().length : 0;
    }

    public Iterator getAttachments() {
        return null;
    }

    public Iterator getAttachments(MimeHeaders headers) {
        return null;
    }

    public void addAttachmentPart(AttachmentPart attachmentpart) {
    }

    public AttachmentPart createAttachmentPart() {
        return null;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public void saveChanges() throws SOAPException {
    }

    public boolean saveRequired() {
        return false;
    }

    public void writeTo(OutputStream output) throws SOAPException, IOException {
    }

    public NodeImpl newNode(Node node) {
        if (node instanceof CharacterData) {
            return new TextImpl(this, (CharacterData)node);
        }
        if (!(node instanceof Element)) {
            return null;
        }
        Element element = (Element)node;
        if (element.hasName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope")) {
            return new SOAPEnvelopeImpl(this, element);
        }
        if (element.hasName("http://schemas.xmlsoap.org/soap/envelope/", "Body")) {
            return new SOAPBodyImpl(this, element);
        }
        if (element.hasName("http://schemas.xmlsoap.org/soap/envelope/", "Fault")) {
            return new SOAPFaultImpl(this, element);
        }
        if (element.hasName("http://schemas.xmlsoap.org/soap/envelope/", "Header")) {
            return new SOAPHeaderImpl(this, element);
        }
        Element parent = element.getParentElement();
        if (parent != null) {
            if (parent.hasName("http://schemas.xmlsoap.org/soap/envelope/", "Header")) {
                return new SOAPHeaderElementImpl(this, element);
            }
            if (parent.hasName("http://schemas.xmlsoap.org/soap/envelope/", "Fault") && element.hasName("detail")) {
                return new DetailImpl(this, element);
            }
            if (parent.hasName("detail")) {
                return new DetailEntryImpl(this, element);
            }
        }
        return new SOAPElementImpl(this, element);
    }

    public electric.soap.SOAPMessage getSOAPMessage() {
        Iterator iterator = this.getMimeHeaders().getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader header = (MimeHeader)iterator.next();
            this.message.addMIMEHeader(header.getName(), header.getValue());
        }
        return this.message;
    }
}

