/*
 * Decompiled with CFR 0.152.
 */
package electric.http.cookies;

import electric.http.cookies.ClientCookie;
import electric.http.cookies.ICookieConstants;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Cookie0
implements ICookieConstants {
    private static SimpleDateFormat dateFormatter;

    static void parse(StringTokenizer tokenizer, ClientCookie cookie, String requestURI) {
        while (tokenizer.hasMoreTokens()) {
            String delim;
            String name = tokenizer.nextToken("=;,").trim();
            String value = null;
            if (tokenizer.hasMoreTokens() && "=".equals(delim = tokenizer.nextToken())) {
                value = tokenizer.nextToken(";").trim();
                if (tokenizer.hasMoreTokens()) {
                    tokenizer.nextToken();
                }
            }
            if (name.equals("expires")) {
                String expires = value;
                Date date = Cookie0.parse(expires);
                int maxAge = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
                cookie.setMaxAge(maxAge);
                continue;
            }
            if (name.equals("path")) {
                String path = value;
                cookie.setPath(path);
                continue;
            }
            if (name.equals("domain")) {
                String domain = value;
                cookie.setDomain(domain);
                continue;
            }
            if (!name.equals("secure")) continue;
            cookie.setSecure(true);
        }
    }

    private static void initDateFormatter() {
        dateFormatter = new SimpleDateFormat("EEEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parse(String string) {
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            return dateFormatter.parse(string, new ParsePosition(0));
        }
    }

    static {
        Cookie0.initDateFormatter();
    }
}

