/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.creation;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.IServiceCreator;
import electric.fabric.services.IServiceManager;
import electric.fabric.services.ServiceInfo;
import electric.fabric.services.ServiceManagerException;
import electric.fabric.services.factory.ObjectFactories;
import electric.fabric.util.ReferenceCache;
import electric.glue.context.ServiceContext;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.Servers;
import electric.util.Context;
import electric.util.UUID;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.http.HTTPUtil;
import electric.util.log.Log;
import electric.util.reflect.Reflect;
import electric.wsdl.util.SignatureGenerator;
import java.io.IOException;
import java.util.Enumeration;

public class ServiceCreator
implements IServiceCreator,
IFabricConstants {
    private IServiceManager serviceManager;
    static /* synthetic */ Class class$electric$fabric$services$IServiceManager;

    public ServiceCreator(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ServiceInfo createService(String path) throws ServiceManagerException {
        if (Log.isLogging(IFabricConstants.SERVICE_MANAGER_EVENT)) {
            Log.log(IFabricConstants.SERVICE_MANAGER_EVENT, (Object)("create " + path));
        }
        try {
            Context context = HTTPUtil.getParametersAsContext(path);
            XURL[] hostsToAvoid = this.getHostsToAvoid(context);
            if (Fabric.isClient() || this.isLocal(hostsToAvoid)) {
                return this.createRemoteService(hostsToAvoid, path);
            }
            return this.createLocalService(context, path);
        }
        catch (ServiceManagerException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    private XURL[] getHostsToAvoid(Context context) {
        Enumeration noendpoints = context.getProperties("avoidHost");
        XURL[] hostsToAvoid = new XURL[]{};
        while (noendpoints.hasMoreElements()) {
            try {
                XURL xurl = new XURL((String)noendpoints.nextElement());
                hostsToAvoid = (XURL[])ArrayUtil.addElement(hostsToAvoid, xurl);
            }
            catch (IOException exception) {
                // empty catch block
            }
        }
        return hostsToAvoid;
    }

    private ServiceInfo createLocalService(Context context, String path) throws ServiceManagerException {
        if (Log.isLogging(IFabricConstants.SERVICE_MANAGER_EVENT)) {
            Log.log(IFabricConstants.SERVICE_MANAGER_EVENT, (Object)("create local service" + path));
        }
        try {
            String signature = context.getStringProperty("service.signature");
            Object object = ObjectFactories.newService(signature, path);
            if (object == null) {
                return null;
            }
            String url = Registry.getPath(object);
            if (url == null) {
                url = this.publish(object, signature);
            }
            if (url == null) {
                throw new ServiceManagerException("could not publish " + object);
            }
            return new ServiceInfo(url + ".wsdl");
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    private String publish(Object object, String signature) throws RegistryException {
        ServiceContext context = new ServiceContext();
        Class[] interfaces = Reflect.getInterfaces(object.getClass());
        Class matchingInterface = this.getInterface(interfaces, signature);
        if (matchingInterface == null) {
            return null;
        }
        context.setProperty("share", "true");
        String path = "/fabric/created/" + new UUID().getKey();
        Registry.publish(path, object, matchingInterface, (Context)context);
        return Registry.getPath(object);
    }

    private Class getInterface(Class[] interfaces, String signature) {
        int i = 0;
        while (i < interfaces.length) {
            if (SignatureGenerator.getSignature(interfaces[i]).equals(signature)) {
                return interfaces[i];
            }
            ++i;
        }
        return null;
    }

    private ServiceInfo createRemoteService(XURL[] hostsToAvoid, String path) throws ServiceManagerException {
        if (Log.isLogging(IFabricConstants.SERVICE_MANAGER_EVENT)) {
            Log.log(IFabricConstants.SERVICE_MANAGER_EVENT, (Object)("create remote service" + path));
        }
        ServiceInfo[] serviceManagers = this.serviceManager.getOnlineServiceManagers();
        serviceManagers = (ServiceInfo[])ArrayUtil.randomizeOrder(serviceManagers);
        int i = 0;
        while (i < serviceManagers.length) {
            ServiceInfo managerServiceInfo = serviceManagers[i];
            XURL wsdlXURL = managerServiceInfo.getWSDLXURL();
            if (!Servers.isLocal(wsdlXURL) && !this.isExcluded(wsdlXURL.getHostAndPortXURL(), hostsToAvoid)) {
                try {
                    IServiceManager serviceManager = (IServiceManager)ReferenceCache.bind(managerServiceInfo.getWSDLURL(), class$electric$fabric$services$IServiceManager == null ? (class$electric$fabric$services$IServiceManager = ServiceCreator.class$("electric.fabric.services.IServiceManager")) : class$electric$fabric$services$IServiceManager);
                    ServiceInfo serviceInfo = serviceManager.createService(path);
                    if (Log.isLogging(IFabricConstants.SERVICE_MANAGER_EVENT)) {
                        Log.log(IFabricConstants.SERVICE_MANAGER_EVENT, (Object)("created " + serviceInfo));
                    }
                    return serviceInfo;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        throw new ServiceManagerException("could not create service " + path);
    }

    private boolean isExcluded(XURL host, XURL[] antiHosts) {
        int i = 0;
        while (i < antiHosts.length) {
            if (host.equals(antiHosts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isLocal(XURL[] antiHosts) {
        int i = 0;
        while (i < antiHosts.length) {
            if (Servers.isLocal(antiHosts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

