/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.broker;

import electric.fabric.services.broker.BrokerException;
import electric.fabric.services.broker.BrokerInfo;
import electric.fabric.services.broker.BrokerLocatorEntry;
import electric.fabric.services.broker.IBroker;
import electric.fabric.services.broker.IBrokerLocator;
import electric.fabric.services.broker.IBrokersListener;
import electric.fabric.services.broker.LocalBrokers;
import electric.util.array.ArrayUtil;
import electric.util.proxy.ProxyFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;

public final class BrokerProxy
implements InvocationHandler,
IBrokersListener {
    private BrokerInfo brokerInfo;
    private IBroker brokerInterface;
    private BrokerLocatorEntry[] brokerLocatorEntries = new BrokerLocatorEntry[0];
    private IBrokerLocator brokerLocator;
    static /* synthetic */ Class class$electric$fabric$services$broker$IBroker;

    public BrokerProxy() {
        ClassLoader loader = this.getClass().getClassLoader();
        Class[] interfaces = new Class[]{class$electric$fabric$services$broker$IBroker == null ? (class$electric$fabric$services$broker$IBroker = BrokerProxy.class$("electric.fabric.services.broker.IBroker")) : class$electric$fabric$services$broker$IBroker};
        this.brokerInterface = (IBroker)ProxyFactory.newProxy(loader, interfaces, this);
        LocalBrokers.addListener(this);
    }

    public IBroker getIBroker() {
        return this.brokerInterface;
    }

    public void addBrokerLocator(String name, IBrokerLocator brokerLocator) {
        BrokerLocatorEntry entry = new BrokerLocatorEntry(name, brokerLocator);
        this.brokerLocatorEntries = (BrokerLocatorEntry[])ArrayUtil.addElement(this.brokerLocatorEntries, entry);
    }

    public void setBrokerLocator(String name) {
        this.brokerLocator = null;
        int i = 0;
        while (i < this.brokerLocatorEntries.length) {
            if (this.brokerLocatorEntries[i].name.equals(name)) {
                this.brokerLocator = this.brokerLocatorEntries[i].locator;
                break;
            }
            ++i;
        }
    }

    public IBrokerLocator getBrokerLocator() {
        return this.brokerLocator;
    }

    public IBrokerLocator getBrokerLocator(String name) {
        int i = 0;
        while (i < this.brokerLocatorEntries.length) {
            if (this.brokerLocatorEntries[i].name.equals(name)) {
                this.brokerLocator = this.brokerLocatorEntries[i].locator;
                return this.brokerLocator;
            }
            ++i;
        }
        return null;
    }

    public void addedLocalBroker(IBroker broker) {
        try {
            this.setBrokerInfo(new BrokerInfo(broker.getURL(), broker));
        }
        catch (BrokerException exception) {}
    }

    public void removedLocalBroker(IBroker broker) {
        this.resetBrokerInfo();
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
        this.brokerInfo = brokerInfo;
    }

    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public void resetBrokerInfo() {
        this.brokerInfo = null;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.brokerInfo != null) {
            try {
                return method.invoke((Object)this.brokerInfo.getBroker(), args);
            }
            catch (Exception exception) {
                this.resetBrokerInfo();
            }
        }
        this.getBroker();
        try {
            return method.invoke((Object)this.brokerInfo.getBroker(), args);
        }
        catch (Exception exception) {
            this.resetBrokerInfo();
            throw exception;
        }
    }

    public synchronized void getBroker() throws RemoteException {
        if (this.brokerInfo != null) {
            return;
        }
        BrokerInfo newBrokerInfo = this.brokerLocator.getBrokerInfo();
        if (newBrokerInfo == null) {
            throw new RemoteException("could not locate broker");
        }
        this.setBrokerInfo(newBrokerInfo);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

