/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services;

import electric.fabric.IFabricConstants;
import electric.fabric.services.IServiceCreator;
import electric.fabric.services.IServiceManager;
import electric.fabric.services.IServiceSelector;
import electric.fabric.services.ServiceInfo;
import electric.fabric.services.ServiceManagerException;
import electric.fabric.services.ServicePath;
import electric.fabric.services.broker.BrokerInfo;
import electric.fabric.services.broker.BrokerProxy;
import electric.fabric.services.broker.IBroker;
import electric.fabric.services.broker.IBrokerLocator;
import electric.glue.context.ServiceContext;
import electric.net.event.NetEvent;
import electric.net.event.NetLog;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import electric.wsdl.util.SignatureGenerator;
import electric.xdb.IXDBConstants;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;

public class ServiceManager
implements IServiceManager,
IFabricConstants,
IXDBConstants {
    private static final long THRESHOLD = 10000L;
    private IReference reference;
    private IBroker broker;
    private String signature;
    private String wsdlURL;
    private BrokerProxy proxy = new BrokerProxy();
    private IServiceCreator creator;
    private IServiceSelector selector;
    private XURL[] intermediariesCache;
    private long timeOfLastIntermediaryCheck;
    static /* synthetic */ Class class$electric$fabric$services$IServiceManager;

    public ServiceManager() throws RegistryException {
        this.broker = this.proxy.getIBroker();
        this.signature = SignatureGenerator.getDocLitSignature(class$electric$fabric$services$IServiceManager == null ? (class$electric$fabric$services$IServiceManager = ServiceManager.class$("electric.fabric.services.IServiceManager")) : class$electric$fabric$services$IServiceManager);
        ServiceContext context = new ServiceContext();
        context.setDocumentStyle();
        Registry.publish("/fabric/serviceManager", (Object)this, class$electric$fabric$services$IServiceManager == null ? (class$electric$fabric$services$IServiceManager = ServiceManager.class$("electric.fabric.services.IServiceManager")) : class$electric$fabric$services$IServiceManager, (Context)context);
    }

    public void setSelector(IServiceSelector selector) {
        this.selector = selector;
    }

    public IServiceSelector getSelector() {
        return this.selector;
    }

    public void setCreator(IServiceCreator creator) {
        this.creator = creator;
    }

    public IServiceCreator getCreator() {
        return this.creator;
    }

    public String getWSDLURL() {
        return this.wsdlURL;
    }

    public IBroker getBroker() {
        return this.broker;
    }

    public BrokerInfo getBrokerInfo() {
        return this.proxy.getBrokerInfo();
    }

    public void addBrokerLocator(String name, IBrokerLocator locator) {
        this.proxy.addBrokerLocator(name, locator);
    }

    public void setBrokerLocator(String name) {
        this.proxy.setBrokerLocator(name);
    }

    public IBrokerLocator getBrokerLocator() {
        return this.proxy.getBrokerLocator();
    }

    public IBrokerLocator getBrokerLocator(String name) {
        return this.proxy.getBrokerLocator(name);
    }

    public synchronized IReference getReference() throws RegistryException {
        if (this.reference != null) {
            return this.reference;
        }
        Class[] interfaces = new Class[]{class$electric$fabric$services$IServiceManager == null ? (class$electric$fabric$services$IServiceManager = ServiceManager.class$("electric.fabric.services.IServiceManager")) : class$electric$fabric$services$IServiceManager};
        Context context = new Context();
        this.reference = Registry.getReference("/fabric/serviceManager", interfaces, context);
        return this.reference;
    }

    public void start() throws Exception {
        this.wsdlURL = Registry.getPath(this) + ".wsdl";
        ServiceInfo serviceInfo = new ServiceInfo(this.wsdlURL);
        serviceInfo.setDescription("fabric service manager");
        serviceInfo.addMetadata("inFabricServer", "true");
        serviceInfo.addMetadata("systemService", "true");
        String endpoint = this.wsdlURL.substring(0, this.wsdlURL.length() - 19) + "soap";
        serviceInfo.addMetadata("soap", endpoint);
        this.publishUsingInfo(serviceInfo);
    }

    public void publishUsingInfo(ServiceInfo serviceInfo) throws ServiceManagerException {
        try {
            this.broker.publish(serviceInfo);
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public void publishUsingWSDL(String wsdlURL) throws ServiceManagerException {
        try {
            this.publishUsingInfo(new ServiceInfo(wsdlURL));
        }
        catch (ServiceManagerException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public void unpublishUsingEndpoint(String endpoint) throws ServiceManagerException {
        try {
            this.broker.unpublish(endpoint);
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public ServiceInfo getServiceInfoForEndpoint(String endpoint) throws ServiceManagerException {
        try {
            return this.broker.getServiceInfoForEndpoint(endpoint);
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public ServiceInfo getServiceInfoForWSDL(String wsdlURL) throws ServiceManagerException {
        try {
            ServiceInfo constraint = new ServiceInfo();
            constraint.setWSDLURL(wsdlURL);
            ServiceInfo[] matches = this.findServicesForConstraint(constraint);
            return matches.length == 0 ? null : matches[0];
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public int getServiceCount() throws ServiceManagerException {
        try {
            return this.broker.getServiceCount();
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public ServiceInfo[] getAllServiceInfo() throws ServiceManagerException {
        try {
            return this.broker.getAllServiceInfo();
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public ServiceInfo[] findServicesForPath(String path) throws ServiceManagerException {
        ServiceInfo constraint = this.getConstraint(path, false);
        return this.findServicesForConstraint(constraint);
    }

    public ServiceInfo[] findServicesForConstraint(ServiceInfo constraint) throws ServiceManagerException {
        try {
            ServiceInfo[] serviceInfos = this.broker.getServiceInfoForConstraint(constraint);
            if (constraint.isOnline()) {
                serviceInfos = this.getOnline(serviceInfos);
            }
            return serviceInfos;
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public ServiceInfo[] getOnlineServiceManagers() throws ServiceManagerException {
        ServiceInfo constraint = new ServiceInfo();
        constraint.setSignature(this.signature);
        constraint.addMetadata("online", "true");
        return this.findServicesForConstraint(constraint);
    }

    public String[] getIntermediaryURLs() throws ServiceManagerException {
        ServiceInfo[] serviceManagers = this.getOnlineServiceManagers();
        String[] urls = new String[serviceManagers.length];
        int i = 0;
        while (i < serviceManagers.length) {
            urls[i] = serviceManagers[i].getMetadata("soap");
            ++i;
        }
        return urls;
    }

    public String[] getGroups() throws ServiceManagerException {
        try {
            return this.broker.getGroups();
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public String getInquiryURL() throws ServiceManagerException {
        try {
            return this.broker.getInquiryURL();
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public String getPublicationURL() throws ServiceManagerException {
        try {
            return this.broker.getPublicationURL();
        }
        catch (Exception exception) {
            throw new ServiceManagerException(exception);
        }
    }

    public ServiceInfo createService(String path) throws ServiceManagerException {
        return this.creator.createService(path);
    }

    public ServicePath selectService(String path) throws ServiceManagerException {
        return this.selector.selectService(path, this.getIntermediaries());
    }

    public ServiceInfo getConstraint(String path, boolean mustBeOnline) throws ServiceManagerException {
        ServiceInfo constraint = new ServiceInfo();
        if (mustBeOnline) {
            constraint.addMetadata("online", "true");
        }
        Context parameters = null;
        try {
            parameters = HTTPUtil.getParametersAsContext(path);
        }
        catch (IOException exception) {
            throw new ServiceManagerException(exception);
        }
        Enumeration enumeration = parameters.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (!name.startsWith("service.")) continue;
            String key = name.substring(IFabricConstants.SERVICE_PREFIX_LENGTH);
            Enumeration values = parameters.getProperties(name);
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                if (key.equals("wsdl")) {
                    constraint.setWSDLURL(value.toString());
                    continue;
                }
                if (value.equals("")) {
                    constraint.addMetadata(key);
                    continue;
                }
                constraint.addMetadata(key, value.toString());
            }
        }
        return constraint;
    }

    private ServiceInfo[] getOnline(ServiceInfo[] serviceInfos) {
        Vector<ServiceInfo> selected = new Vector<ServiceInfo>();
        int i = 0;
        while (i < serviceInfos.length) {
            ServiceInfo serviceInfo = serviceInfos[i];
            if (serviceInfo.isOnline()) {
                XURL endpoint = serviceInfo.getEndpointXURL();
                NetEvent event = NetLog.getEvent(endpoint);
                if (event == null) {
                    selected.addElement(serviceInfo);
                } else if (event.getTime() < serviceInfo.getSince()) {
                    selected.addElement(serviceInfo);
                    NetLog.removeEvents(endpoint);
                }
            }
            ++i;
        }
        Object[] results = new ServiceInfo[selected.size()];
        selected.copyInto(results);
        return results;
    }

    private synchronized XURL[] getIntermediaries() throws ServiceManagerException {
        if (this.intermediariesCache != null && System.currentTimeMillis() - this.timeOfLastIntermediaryCheck < 10000L) {
            return this.intermediariesCache;
        }
        this.timeOfLastIntermediaryCheck = System.currentTimeMillis();
        String[] intermediaryURLs = this.getIntermediaryURLs();
        this.intermediariesCache = new XURL[intermediaryURLs.length];
        int i = 0;
        while (i < intermediaryURLs.length) {
            try {
                this.intermediariesCache[i] = new XURL(intermediaryURLs[i]);
            }
            catch (MalformedURLException exception) {
                // empty catch block
            }
            ++i;
        }
        return this.intermediariesCache;
    }

    public void livenessPing() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

