/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.rules.conditions.time;

import electric.fabric.rules.conditions.IBinaryCondition;
import electric.soap.SOAPMessage;
import electric.util.Context;

public class ResponseTimeThreshold
implements IBinaryCondition {
    private static final String SEND_REQUEST_TIME = "sendRequestTime";
    private static final String RECEIVE_RESPONSE_TIME = "receiveResponseTime";
    private long threshold;

    public ResponseTimeThreshold() {
    }

    public ResponseTimeThreshold(long threshold) {
        this.threshold = threshold;
    }

    public String toString() {
        return "ResponseTimeThreshold( threshold=" + this.threshold + " )";
    }

    public long getThreshold() {
        return this.threshold;
    }

    public boolean satisfiedBy(SOAPMessage request, SOAPMessage response, Context messageContext) {
        long sendRequestTime = (Long)messageContext.getProperty(SEND_REQUEST_TIME);
        long receiveResponseTime = (Long)messageContext.getProperty(RECEIVE_RESPONSE_TIME);
        long duration = receiveResponseTime - sendRequestTime;
        return duration > this.threshold;
    }
}

