/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.endpoints;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.endpoints.Endpoint;
import electric.fabric.endpoints.EndpointInfo;
import electric.fabric.endpoints.EndpointInfoUploader;
import electric.fabric.endpoints.EndpointManagerException;
import electric.fabric.endpoints.EndpointManagerLookup;
import electric.fabric.endpoints.EndpointRefresher;
import electric.fabric.endpoints.IEndpointManager;
import electric.fabric.endpoints.RuleRefresher;
import electric.fabric.endpoints.performance.GetPerformanceInfo;
import electric.fabric.endpoints.performance.IPerformance;
import electric.fabric.endpoints.performance.PerformanceInfo;
import electric.fabric.rules.Rule;
import electric.fabric.rules.RuleManagerException;
import electric.fabric.services.ServiceInfo;
import electric.glue.context.ServiceContext;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.thread.ThreadPool;
import electric.util.time.TimeUtil;
import electric.xdb.Data;
import electric.xdb.IXDBConstants;
import electric.xdb.Query;
import electric.xdb.Result;
import electric.xdb.XDBException;
import electric.xdb.client.IXDBClient;
import electric.xdb.client.XDBClients;
import electric.xml.Element;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public final class EndpointManager
implements IEndpointManager,
IFabricConstants,
IXDBConstants {
    private HashMap urlToWeakReference = new HashMap();
    private IReference reference;
    private IXDBClient endpoints = XDBClients.getClient("endpoints");
    private String wsdlURL;
    private EndpointRefresher endpointRefresher;
    private RuleRefresher ruleRefresher;
    static /* synthetic */ Class class$electric$fabric$endpoints$IEndpointManager;

    public EndpointManager() throws RegistryException {
        ServiceContext context = new ServiceContext();
        context.setDocumentStyle();
        Registry.publish("/fabric/endpointManager", (Object)this, class$electric$fabric$endpoints$IEndpointManager == null ? (class$electric$fabric$endpoints$IEndpointManager = EndpointManager.class$("electric.fabric.endpoints.IEndpointManager")) : class$electric$fabric$endpoints$IEndpointManager, (Context)context);
    }

    public String getWSDLURL() {
        return this.wsdlURL;
    }

    public IXDBClient getXDBClient() {
        return this.endpoints;
    }

    public synchronized IReference getReference() throws RegistryException {
        if (this.reference != null) {
            return this.reference;
        }
        Class[] interfaces = new Class[]{class$electric$fabric$endpoints$IEndpointManager == null ? (class$electric$fabric$endpoints$IEndpointManager = EndpointManager.class$("electric.fabric.endpoints.IEndpointManager")) : class$electric$fabric$endpoints$IEndpointManager};
        Context context = new Context();
        this.reference = Registry.getReference("/fabric/endpointManager", interfaces, context);
        return this.reference;
    }

    public void start() throws Exception {
        this.wsdlURL = Registry.getPath(this) + ".wsdl";
        ServiceInfo serviceInfo = new ServiceInfo(this.wsdlURL);
        serviceInfo.setDescription("fabric endpoint manager");
        serviceInfo.addMetadata("inFabricServer", "true");
        serviceInfo.addMetadata("systemService", "true");
        Fabric.getServiceManager().publishUsingInfo(serviceInfo);
        this.endpointRefresher = new EndpointRefresher(this);
        ThreadPool.getShared().run(this.endpointRefresher);
        this.ruleRefresher = new RuleRefresher(this);
        ThreadPool.getShared().run(this.ruleRefresher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLocalEndpointURLs() throws EndpointManagerException {
        HashMap hashMap = this.urlToWeakReference;
        synchronized (hashMap) {
            Vector<String> urls = new Vector<String>();
            Iterator iterator = this.urlToWeakReference.values().iterator();
            while (iterator.hasNext()) {
                Endpoint endpoint = (Endpoint)((WeakReference)iterator.next()).get();
                if (endpoint == null) continue;
                urls.addElement(endpoint.getURL());
            }
            Object[] array = new String[urls.size()];
            urls.copyInto(array);
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getEndpoint(String url) throws EndpointManagerException {
        Endpoint endpoint = null;
        HashMap hashMap = this.urlToWeakReference;
        synchronized (hashMap) {
            WeakReference weakReference = (WeakReference)this.urlToWeakReference.get(url);
            if (weakReference != null && (endpoint = (Endpoint)weakReference.get()) != null) {
                return endpoint;
            }
            endpoint = new Endpoint(url);
            this.urlToWeakReference.put(url, new WeakReference<Endpoint>(endpoint));
        }
        Rule[] rules = this.getRulesForAllAndEndpoint(url);
        endpoint.setRules(rules);
        EndpointInfo endpointInfo = new EndpointInfo(endpoint.getKey(), url, this.wsdlURL);
        new EndpointInfoUploader(this).upload(endpointInfo);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getEndpointsToRefresh() throws EndpointManagerException {
        long now = TimeUtil.now();
        Vector<Endpoint> endpoints = new Vector<Endpoint>();
        HashMap hashMap = this.urlToWeakReference;
        synchronized (hashMap) {
            Iterator iterator = this.urlToWeakReference.values().iterator();
            while (iterator.hasNext()) {
                Endpoint endpoint = (Endpoint)((WeakReference)iterator.next()).get();
                if (endpoint == null) {
                    iterator.remove();
                    continue;
                }
                if (now - endpoint.getTimeOfLastRefresh() <= 180000L) continue;
                endpoints.addElement(endpoint);
            }
        }
        return endpoints;
    }

    public EndpointInfo[] getEndpointInfoForURL(String url) throws EndpointManagerException {
        Element envelope = new Element("Envelope");
        Element body = envelope.addElement("Body");
        Element endpointInfoElement = body.addElement("EndpointInfo");
        Element endpointElement = endpointInfoElement.addElement("url");
        endpointElement.setString(url);
        Query query = new Query(envelope);
        Data[] matches = null;
        try {
            matches = this.endpoints.getDataForQuery(query);
        }
        catch (XDBException exception) {
            throw new EndpointManagerException(exception);
        }
        EndpointInfo[] endpointInfo = new EndpointInfo[matches.length];
        int i = 0;
        while (i < matches.length) {
            endpointInfo[i] = (EndpointInfo)matches[i].getObject();
            ++i;
        }
        return endpointInfo;
    }

    public Rule[] getRulesForAllAndEndpoint(String url) throws EndpointManagerException {
        if (url.equals("*")) {
            return this.getRulesForEndpointWithURL("*");
        }
        Rule[] rules1 = this.getRulesForEndpointWithURL("*");
        Rule[] rules2 = this.getRulesForEndpointWithURL(url);
        return (Rule[])ArrayUtil.addElements(rules1, rules2);
    }

    public Rule[] getRulesForEndpointWithURL(String url) throws EndpointManagerException {
        Element envelope = new Element("Envelope");
        Element body = envelope.addElement("Body");
        Element rule = body.addElement("Rule");
        rule.setString("url", url);
        Query query = new Query(envelope);
        try {
            return Fabric.getRuleManager().getRulesForQuery(query);
        }
        catch (RuleManagerException exception) {
            throw new EndpointManagerException(exception);
        }
    }

    public PerformanceInfo getLocalPerformanceInfoForEndpoint(String url, long start, long stop) throws EndpointManagerException {
        WeakReference weakReference = (WeakReference)this.urlToWeakReference.get(url);
        if (weakReference == null) {
            return null;
        }
        Endpoint endpoint = (Endpoint)weakReference.get();
        if (endpoint == null) {
            return null;
        }
        Rule rule = endpoint.getRuleWithKey("performance");
        if (rule == null) {
            return null;
        }
        IPerformance performance = (IPerformance)((Object)rule.getProcessor());
        return performance.getPerformanceInfo(start, stop);
    }

    public PerformanceInfo getPerformanceInfoForEndpoint(String endpoint, long start, long stop) throws EndpointManagerException {
        EndpointManagerLookup action = new EndpointManagerLookup(endpoint);
        Result result = null;
        try {
            result = this.endpoints.perform(action);
        }
        catch (XDBException exception) {
            throw new EndpointManagerException(exception);
        }
        String[] urls = (String[])result.getValue();
        if (urls.length == 0) {
            return null;
        }
        GetPerformanceInfo command = new GetPerformanceInfo(urls, endpoint, start, stop);
        command.start();
        return command.getPerformanceInfo();
    }

    public void livenessPing() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

