/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.server;

import electric.cluster.IClusterConstants;
import electric.cluster.IClusteredApplication;
import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceInfo;
import electric.glue.context.ProxyContext;
import electric.registry.Registry;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.IMIMEConstants;
import electric.util.mime.MemoryDataHandler;
import electric.webserver.WebServer;
import electric.webserver.WebServers;
import electric.wsdl.util.SignatureGenerator;

public class AppDiscovery
implements ILoggingConstants,
IClusterConstants,
IFabricConstants,
IMIMEConstants {
    static /* synthetic */ Class class$electric$cluster$IClusteredApplication;

    public static IClusteredApplication[] getLocalApplications() {
        IClusteredApplication[] applications = new IClusteredApplication[]{};
        WebServer[] webServers = WebServers.getWebServers();
        String query = AppDiscovery.getQueryString(null, webServers[0].getXURL().toString());
        try {
            ServiceInfo[] serviceInfos = Fabric.getServiceManager().findServicesForPath(query);
            int i = 0;
            while (i < serviceInfos.length) {
                IClusteredApplication application = (IClusteredApplication)Registry.bind(serviceInfos[i].getWSDLURL(), class$electric$cluster$IClusteredApplication == null ? AppDiscovery.class$("electric.cluster.IClusteredApplication") : class$electric$cluster$IClusteredApplication);
                applications = (IClusteredApplication[])ArrayUtil.addElement(applications, application);
                ++i;
            }
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception discovering application services", exception);
            }
            return new IClusteredApplication[0];
        }
        return applications;
    }

    public static IClusteredApplication[] getApplications(String appName) {
        IClusteredApplication[] applications;
        block5: {
            applications = new IClusteredApplication[]{};
            try {
                String query = AppDiscovery.getQueryString(appName, null);
                ServiceInfo[] information = Fabric.getServiceManager().findServicesForPath(query);
                if (information == null || information.length == 0) {
                    return applications;
                }
                WebServer[] webServers = WebServers.getWebServers();
                XURL homeURL = webServers[0].getXURL();
                int i = 0;
                while (i < information.length) {
                    if (!AppDiscovery.isLocalApplication(homeURL, information[i].getHostAndPortXURL())) {
                        ProxyContext context = new ProxyContext();
                        context.setProperty("*/* dataHandler", new MemoryDataHandler());
                        IClusteredApplication application = (IClusteredApplication)Registry.bind(information[i].getWSDLURL(), class$electric$cluster$IClusteredApplication == null ? AppDiscovery.class$("electric.cluster.IClusteredApplication") : class$electric$cluster$IClusteredApplication, (Context)context);
                        applications = (IClusteredApplication[])ArrayUtil.addElement(applications, application);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception binding to remote applications", exception);
            }
        }
        return applications;
    }

    private static boolean isLocalApplication(XURL homeURL, XURL serviceURL) {
        return homeURL.getHost().equals(serviceURL.getHost()) && homeURL.getPort() == serviceURL.getPort();
    }

    private static String getQueryString(String appName, String wssUrl) {
        String signature = SignatureGenerator.getSignature(class$electric$cluster$IClusteredApplication == null ? (class$electric$cluster$IClusteredApplication = AppDiscovery.class$("electric.cluster.IClusteredApplication")) : class$electric$cluster$IClusteredApplication);
        StringBuffer query = new StringBuffer("service.signature=");
        query.append(signature);
        query.append("&service.online=true");
        if (appName != null) {
            query.append("&service.appName=");
            query.append(appName);
        }
        if (wssUrl != null) {
            query.append("&service.wssUrl=");
            query.append(wssUrl);
        }
        return query.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

