/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.monitor;

import electric.cluster.IClusterConstants;
import electric.cluster.IClusteredApplication;
import electric.cluster.server.AppDiscovery;
import electric.glue.IGLUELoggingConstants;
import electric.util.array.ArrayUtil;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredRoot;
import electric.util.file.FileUtil;
import electric.util.io.Streams;
import electric.util.jar.Jar;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.util.thread.Lock;
import java.io.File;
import java.io.IOException;

public class ClusteredAppMonitor
implements IFileEventListener,
IGLUELoggingConstants,
IClusterConstants {
    private String appName;
    private String directoryPath;
    private MonitoredRoot root;
    private boolean initialized = false;

    public ClusteredAppMonitor(String appName, String directoryPath) {
        this.appName = appName;
        this.directoryPath = directoryPath.endsWith(File.separator) ? directoryPath : directoryPath + File.separator;
        this.root = new MonitoredRoot(new File(directoryPath), true);
        this.root.addEventListener(this);
    }

    public void start() {
        this.root.start();
    }

    public void stop() {
        this.root.stop();
    }

    public void filesAdded(File[] files) {
        if (!this.initialized) {
            this.initialized = true;
            return;
        }
        this.packageFiles(files);
    }

    public void filesRemoved(File[] files) {
        IClusteredApplication[] applications = AppDiscovery.getApplications(this.appName);
        if (applications.length == 0) {
            return;
        }
        String[] filesRemoved = new String[]{};
        int i = 0;
        while (i < files.length) {
            block5: {
                try {
                    String deletedPath = files[i].getCanonicalPath().substring(this.directoryPath.length());
                    filesRemoved = (String[])ArrayUtil.addElement(filesRemoved, deletedPath);
                }
                catch (IOException exception) {
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception getting path to " + files[i], exception);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < applications.length) {
            applications[i2].deleteFiles(filesRemoved);
            ++i2;
        }
    }

    public void filesModified(File[] files) {
        this.packageFiles(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packageFiles(File[] files) {
        if (files != null && files.length == 1 && files[0].getName().equalsIgnoreCase(this.appName + ".jar")) {
            return;
        }
        Lock lock = null;
        StringBuffer jarPath = new StringBuffer(this.directoryPath);
        jarPath.append(this.appName);
        jarPath.append(".jar");
        try {
            try {
                lock = Lock.obtain(jarPath.toString());
                int i = 0;
                while (i < files.length) {
                    if (files[i].isFile()) {
                        String relativePath = files[i].getCanonicalPath().substring(this.directoryPath.length());
                        Jar.saveFile(jarPath.toString(), relativePath, new String(Streams.readFully(files[i])));
                    }
                    ++i;
                }
            }
            catch (IOException exception) {
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception saving entry to jar file", exception);
                }
                Object var7_9 = null;
                if (lock != null) {
                    lock.release();
                }
            }
            Object var7_8 = null;
            if (lock != null) {
                lock.release();
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (lock != null) {
                lock.release();
            }
            throw throwable;
        }
        File jarFile = new File(jarPath.toString());
        if (jarFile.exists()) {
            this.updateCluster(jarFile);
        }
        FileUtil.delete(jarFile);
    }

    private void updateCluster(File jarFile) {
        block3: {
            IClusteredApplication[] applications = AppDiscovery.getApplications(this.appName);
            try {
                int i = 0;
                while (i < applications.length) {
                    applications[i].uploadApplication(new MIMEData(jarFile));
                    ++i;
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception trying to update cluster with " + jarFile.getName(), exception);
            }
        }
    }
}

