/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.services;

import electric.application.web.managed.ManagedObject;
import electric.application.web.services.ServiceManager;
import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.service.INeedInstantiator;
import electric.service.IService;
import electric.service.descriptor.ServiceDescriptor;
import electric.util.Context;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;

public final class ManagedService
extends ManagedObject {
    private String path;
    private ServiceDescriptor descriptor;

    public ManagedService(ServiceManager serviceManager, ServiceDescriptor descriptor, String path) {
        super(serviceManager);
        this.descriptor = descriptor;
        this.path = path;
    }

    public void begin() throws Throwable {
        if (!this.isEnabled()) {
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": service " + this.path + " disabled"));
            }
            return;
        }
        try {
            this.descriptor.setClassLoader(this.getClassLoader());
            this.setMetadata();
            IService serviceObject = Registry.getServiceFactory().newService(this.descriptor.getObject());
            if (serviceObject instanceof INeedInstantiator) {
                ((INeedInstantiator)((Object)serviceObject)).setInstantiator(this.descriptor.instantiator);
            }
            Registry.publish(this.path, (Object)serviceObject, this.descriptor.getContext());
            this.setState(3);
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": started service " + this.path));
            }
        }
        catch (Throwable exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not start service " + this.path, exception);
            }
            throw exception;
        }
    }

    private void setMetadata() {
        try {
            Context serviceContext = this.descriptor.getContext();
            serviceContext.setProperty("service.appName", this.getAppName());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private boolean isEnabled() {
        return this.descriptor.publish;
    }

    public void end() throws Exception {
        try {
            Object serviceObject = Registry.get(this.path);
            if (serviceObject == null) {
                return;
            }
            Registry.unpublish(this.path);
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": stopped service " + this.path));
            }
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not stop service " + this.path, exception);
            }
            throw exception;
        }
    }
}

