/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.maps;

import electric.application.web.maps.MapManager;
import electric.glue.IGLUELoggingConstants;
import electric.util.directory.filters.ExtensionFilter;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredRoot;
import java.io.File;

public final class MapMonitor
implements IFileEventListener,
IGLUELoggingConstants {
    private MapManager mapManager;
    private MonitoredRoot root;

    public MapMonitor(MapManager mapManager, String path) {
        this.mapManager = mapManager;
        ExtensionFilter filter = new ExtensionFilter(new String[]{".map"});
        this.root = new MonitoredRoot(new File(path), true, false, filter, true);
        this.root.addEventListener(this);
    }

    public void start() {
        this.root.start();
    }

    public void stop() {
        this.root.stop();
    }

    public void filesAdded(File[] files) {
        int i = 0;
        while (i < files.length) {
            this.mapManager.addMapping(files[i]);
            ++i;
        }
    }

    public void filesRemoved(File[] files) {
    }

    public void filesModified(File[] files) {
    }
}

