/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web;

import electric.application.Application;
import electric.application.Applications;
import electric.application.DeploymentException;
import electric.application.ServicesSummary;
import electric.application.web.IStateConstants;
import electric.application.web.IWebApplicationListener;
import electric.application.web.classes.ClassManager;
import electric.application.web.maps.MapManager;
import electric.application.web.servers.ServerManager;
import electric.application.web.services.ServiceManager;
import electric.application.web.servlets.ServletDescriptor;
import electric.application.web.servlets.ServletManager;
import electric.glue.IGLUEConfigConstants;
import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ThreadContext;
import electric.glue.std.config.IConfigConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.service.descriptor.ServiceDescriptor;
import electric.service.ejb.StatelessSessionBeanService;
import electric.service.object.ObjectService;
import electric.service.virtual.VirtualService;
import electric.servlet.Config;
import electric.servlet.HTTPContext;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.classpath.IClassPathSource;
import electric.util.file.FileUtil;
import electric.util.fileloader.IFileLoader;
import electric.util.fileloader.filesystem.FileSystemLoader;
import electric.util.jar.Jar;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.util.path.PathUtil;
import electric.util.product.Product;
import electric.util.thread.IdleTask;
import electric.xml.Element;
import electric.xml.io.Mappings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;

public class WebApplication
extends Application
implements IStateConstants,
IConfigConstants,
IGLUEContextConstants,
IGLUEConfigConstants {
    private static final String GLUE_APPHOME = "." + File.separator;
    private static boolean hotDeploy = true;
    private static boolean remoteAccessEnabled = false;
    private static boolean allowEnable = true;
    private int state = 1;
    private String appPath;
    private String appURL;
    private ServiceManager serviceManager;
    private MapManager mapManager;
    private ServletManager servletManager;
    private ClassManager classesManager;
    private ServerManager serverManager;
    private IWebApplicationListener[] listeners = new IWebApplicationListener[0];

    public WebApplication(IFileLoader loader) {
        this.setFileLoader(loader);
    }

    public WebApplication(String appPath) {
        this.setFileLoader(new FileSystemLoader());
        this.initAppPathAndName(appPath);
    }

    public WebApplication(String appPath, String appURL) {
        this(appPath);
        this.appURL = appURL;
    }

    public WebApplication(String name, IFileLoader fileLoader) {
        this.setFileLoader(fileLoader);
        this.setAppPath(File.separator);
        this.setAppName(name);
    }

    public synchronized void addListener(IWebApplicationListener listener) {
        this.listeners = (IWebApplicationListener[])ArrayUtil.addElement(this.listeners, listener);
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
        if (!this.appPath.endsWith(File.separator)) {
            this.appPath = this.appPath + File.separator;
        }
    }

    public String getAppURL() {
        return this.appURL;
    }

    public String getWebInfRoot() {
        return this.getAppPath() + "WEB-INF" + File.separator;
    }

    public String getClassesRoot() {
        return this.getWebInfRoot() + "classes" + File.separator;
    }

    public String getLibRoot() {
        return this.getWebInfRoot() + "lib" + File.separator;
    }

    public String getServicesRoot() {
        return this.getWebInfRoot() + "services" + File.separator;
    }

    public String getMapsRoot() {
        return this.getWebInfRoot() + "maps" + File.separator;
    }

    public String getTmpRoot() {
        return this.getWebInfRoot() + "tmp" + File.separator;
    }

    public static boolean isHotDeploy() {
        return hotDeploy;
    }

    public static void setHotDeploy(boolean hotDeploy) {
        WebApplication.hotDeploy = hotDeploy;
    }

    public boolean isHotDeployable() {
        return WebApplication.isHotDeploy() && this.getFileLoader().isFileSourceHotDeployable();
    }

    public static void enable() {
        if (remoteAccessEnabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("Remote deployment cannot be enabled once it is disabled");
        }
        remoteAccessEnabled = Enabler.enable();
    }

    public static boolean isEnabled() {
        return remoteAccessEnabled;
    }

    public static void disable() {
        remoteAccessEnabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"Remote deployment feature disabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        if (this.state == 3) {
            return;
        }
        Context.thread().setProperty("application", this);
        try {
            try {
                Element config = Product.getConfig("glue", this.getAppPath());
                this.setConfig(config);
                Product.startupAsServer(this.getAppPath(), config, this);
                Mappings.clear();
                this.createManagers();
                this.startManagers();
                this.state = 3;
            }
            catch (Throwable exception) {
                this.state = 5;
                if (exception instanceof InvocationTargetException) {
                    exception = ((InvocationTargetException)exception).getTargetException();
                }
                if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                    Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not start", exception);
                }
                Object var3_5 = null;
                Context.thread();
                Context.remove("application");
                return;
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            Context.thread();
            Context.remove("application");
            throw throwable;
        }
        Context.thread();
        Context.remove("application");
    }

    public void stop() {
        block3: {
            if (this.state != 3) {
                return;
            }
            try {
                this.stopManagers();
                this.state = 4;
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not stop", exception);
            }
        }
    }

    public void restart() {
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": restarting"));
        }
        IdleTask task = new IdleTask();
        this.stop();
        this.start();
        task.stop();
    }

    private void createManagers() throws Exception {
        if (this.mapManager == null) {
            this.mapManager = new MapManager(this);
        }
        if (!Applications.isHosted() && this.servletManager == null) {
            this.servletManager = new ServletManager(this);
        }
        if (this.serverManager == null) {
            this.serverManager = new ServerManager(this);
        }
        if (this.serviceManager == null) {
            this.serviceManager = new ServiceManager(this);
        }
        if (this.classesManager == null) {
            this.classesManager = new ClassManager(this);
        }
    }

    private void startManagers() throws Exception {
        this.mapManager.start();
        if (this.servletManager != null) {
            this.servletManager.start();
        }
        this.serverManager.start();
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].startedServers();
            ++i;
        }
        this.serviceManager.start();
        this.classesManager.start();
    }

    private void stopManagers() throws Exception {
        this.mapManager.stop();
        if (this.servletManager != null) {
            this.servletManager.stop();
        }
        this.serverManager.stop();
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].stoppedServers();
            ++i;
        }
        this.serviceManager.stop();
        this.classesManager.stop();
    }

    public IClassPathSource getClassPathSource() {
        return this.classesManager.getClassPathSource();
    }

    public void addJar(String filename, MIMEData jar) throws DeploymentException {
        this.checkRemoteAccess();
        this.classesManager.addJar(filename, jar);
    }

    public boolean removeJar(String filename) throws DeploymentException {
        this.checkRemoteAccess();
        return this.classesManager.removeJar(filename);
    }

    public void uploadApplication(MIMEData jar) throws DeploymentException, IOException {
        ZipInputStream zipStream = new ZipInputStream(jar.getInputStream());
        Jar.unjarFile(new File(this.appPath), zipStream);
    }

    public void deleteFiles(String[] filenames) {
        int i = 0;
        while (i < filenames.length) {
            String filePath = PathUtil.normalizeSlashes(this.appPath + filenames[i]);
            FileUtil.delete(new File(filePath));
            ++i;
        }
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void addServiceUsingDescriptor(String path, ServiceDescriptor descriptor) throws DeploymentException {
        this.checkRemoteAccess();
        this.serviceManager.addService(path, descriptor);
    }

    public void addService(String path, MIMEData descriptor) throws DeploymentException {
        this.checkRemoteAccess();
        this.serviceManager.addService(path, descriptor);
    }

    public boolean removeService(String path) throws DeploymentException {
        this.checkRemoteAccess();
        return this.serviceManager.removeService(path);
    }

    public void enableService(String name) throws DeploymentException {
        this.checkRemoteAccess();
        this.serviceManager.enableService(name);
    }

    public void disableService(String name) throws DeploymentException {
        this.checkRemoteAccess();
        this.serviceManager.disableService(name);
    }

    public String[] getServicePaths() {
        return this.getServiceManager().getNameList();
    }

    public ServicesSummary getServicesSummary() {
        ServicesSummary summary = new ServicesSummary();
        String[] paths = this.getServicePaths();
        int i = 0;
        while (i < paths.length) {
            block14: {
                Object object = null;
                try {
                    object = Registry.get(paths[i].replace('\\', '/'));
                }
                catch (RegistryException exception) {
                    exception.printStackTrace();
                    break block14;
                }
                if (object == null) {
                    ++summary.disabledServices;
                } else if (object instanceof ObjectService) {
                    ++summary.javaObjectServices;
                    int activationMode = ((ObjectService)object).getMode();
                    if (activationMode == 0) {
                        ++summary.applicationActivation;
                    } else if (activationMode == 1) {
                        ++summary.requestActivation;
                    } else {
                        ++summary.sessionActivation;
                    }
                } else if (object instanceof StatelessSessionBeanService) {
                    ++summary.ejbObjectServices;
                } else if (object instanceof VirtualService) {
                    ++summary.virtualObjectServices;
                }
            }
            ++i;
        }
        return summary;
    }

    public ServletManager getServletManager() {
        return this.servletManager;
    }

    public void addServlet(String name, String servletClass, String urlPattern) throws DeploymentException {
        throw new DeploymentException("adding servlets is not supported");
    }

    public boolean removeServlet(String name) throws DeploymentException {
        throw new DeploymentException("removing servlets is not supported");
    }

    public void enableServlet(String name) throws DeploymentException {
        this.checkRemoteAccess();
        this.servletManager.enableServlet(name);
    }

    public void disableServlet(String name) throws DeploymentException {
        this.checkRemoteAccess();
        this.servletManager.disableServlet(name);
    }

    public String[] getServletNames() throws DeploymentException {
        return this.servletManager.getServletNames();
    }

    public ServletDescriptor getServletDescriptor(String servletName) throws DeploymentException {
        ServletDescriptor descriptor = new ServletDescriptor();
        HTTPContext context = this.servletManager.getServletContext(servletName);
        Config servlet = context.getConfigWithServletName(servletName);
        descriptor.servletClassName = servlet.getClassName();
        descriptor.initParameters = servlet.getInitParameters();
        descriptor.loadOnStartup = servlet.getLoadOnStartup();
        descriptor.urlPatterns = context.getServletMappings(servletName);
        return descriptor;
    }

    private void checkRemoteAccess() throws DeploymentException {
        if (remoteAccessEnabled) {
            return;
        }
        HttpServletRequest request = ThreadContext.getHttpRequest();
        if (request == null) {
            return;
        }
        if (!new XURL(null, request.getRemoteAddr(), 0, null, null).hasLocalHost()) {
            throw new DeploymentException("remote deployment is disabled");
        }
    }

    private void initAppPathAndName(String appPath) {
        if (!this.getFileLoader().exists(appPath)) {
            appPath = WebApplication.getAppHome() + appPath;
            if (!this.getFileLoader().exists(appPath)) {
                throw new IllegalArgumentException("unable to find application directory " + appPath);
            }
        }
        File appPathDir = new File(appPath);
        if (!appPath.equals(File.separator) && appPathDir.exists()) {
            try {
                appPath = appPathDir.getCanonicalPath();
            }
            catch (Exception exception) {
                appPath = appPathDir.getAbsolutePath();
            }
        }
        if (!(appPath = PathUtil.normalizeSlashes(appPath)).endsWith(File.separator)) {
            appPath = appPath + File.separator;
        }
        String noSlashPath = appPath.substring(0, appPath.length() - 1);
        String appName = noSlashPath.substring(noSlashPath.lastIndexOf(File.separator) + 1);
        this.setAppPath(appPath);
        this.setAppName(appName);
    }

    public static String getAppHome() {
        String appHome = Context.getSystemProperty("glue.apphome");
        appHome = (String)Context.getProperty(Context.application(), "glue.apphome", appHome);
        if (appHome == null) {
            appHome = GLUE_APPHOME;
        }
        if (!appHome.endsWith(File.separator)) {
            appHome = appHome + File.separator;
        }
        return appHome;
    }
}

