/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginManager;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.BaseFileServerServlet;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.plugin.util.LastModifiedHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginResourceDownload
implements DownloadStrategy {
    private static final Log log = LogFactory.getLog((Class)PluginResourceDownload.class);
    private PluginManager pluginManager;

    public PluginResourceDownload() {
    }

    public PluginResourceDownload(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public boolean matches(String urlPath) {
        return urlPath.indexOf(BaseFileServerServlet.SERVLET_PATH + "/" + "resources") != -1;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void serveFile(BaseFileServerServlet servlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String[] parts = this.splitIntoLibraryAndResource(httpServletRequest.getRequestURI(), servlet);
        if (parts.length == 2) {
            this.servePluginResource(servlet, httpServletRequest, httpServletResponse, parts[0], parts[1]);
        } else {
            log.info((Object)("Invalid resource path spec: " + httpServletRequest.getRequestURI()));
            httpServletResponse.sendError(404);
        }
    }

    private void servePluginResource(BaseFileServerServlet servlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String moduleKey, String filePath) throws IOException {
        ModuleDescriptor moduleDescriptor = this.pluginManager.getPluginModule(moduleKey);
        if (moduleDescriptor != null && this.pluginManager.isPluginModuleEnabled(moduleKey)) {
            DownloadableResource resource = this.getResourceFromModule(moduleDescriptor, filePath, servlet);
            if (resource == null) {
                resource = this.getResourceFromPlugin(moduleKey, filePath, servlet);
            }
            if (resource != null) {
                if (!this.checkResourceNotModified(resource, httpServletRequest, httpServletResponse)) {
                    this.serveDownloadableResource(servlet, httpServletResponse, resource);
                }
            } else {
                log.info((Object)("Unable to find resource for module: " + moduleKey + " and path: " + filePath));
            }
        } else {
            log.info((Object)("Module not found: " + moduleKey));
            httpServletResponse.sendError(404);
        }
    }

    private boolean checkResourceNotModified(DownloadableResource resource, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Plugin plugin = this.pluginManager.getPlugin(resource.getPluginKey());
        Date resourceLastModifiedDate = plugin.getDateLoaded() == null ? new Date() : plugin.getDateLoaded();
        LastModifiedHandler lastModifiedHandler = new LastModifiedHandler(resourceLastModifiedDate);
        return lastModifiedHandler.checkRequest(httpServletRequest, httpServletResponse);
    }

    private DownloadableResource getResourceFromPlugin(String moduleKey, String filePath, BaseFileServerServlet servlet) {
        if (moduleKey.indexOf(58) < 0 || moduleKey.indexOf(58) == moduleKey.length() - 1) {
            return null;
        }
        Plugin plugin = this.pluginManager.getPlugin(moduleKey.substring(0, moduleKey.indexOf(58)));
        if (plugin == null) {
            return null;
        }
        return this.getResourceFromPlugin(plugin, filePath, "", servlet);
    }

    private DownloadableResource getResourceFromPlugin(Plugin plugin, String resourcePath, String filePath, BaseFileServerServlet servlet) {
        ResourceLocation rd = plugin.getResourceLocation("download", resourcePath);
        if (rd != null) {
            return new DownloadableResource(servlet, plugin.getKey(), rd, filePath);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromPlugin(plugin, nextParts[0], nextParts[1] + filePath, servlet);
    }

    private DownloadableResource getResourceFromModule(ModuleDescriptor moduleDescriptor, String filePath, BaseFileServerServlet servlet) {
        return this.getResourceFromModule(moduleDescriptor, filePath, "", servlet);
    }

    private DownloadableResource getResourceFromModule(ModuleDescriptor moduleDescriptor, String resourcePath, String filePath, BaseFileServerServlet servlet) {
        ResourceLocation rd = moduleDescriptor.getResourceLocation("download", resourcePath);
        if (rd != null) {
            return new DownloadableResource(servlet, moduleDescriptor.getPluginKey(), rd, filePath);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromModule(moduleDescriptor, nextParts[0], nextParts[1] + filePath, servlet);
    }

    private String[] splitLastPathPart(String resourcePath) {
        String slash = "";
        while (resourcePath.endsWith("/")) {
            slash = "/";
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        int i = resourcePath.lastIndexOf(47);
        if (i < 0) {
            return null;
        }
        return new String[]{resourcePath.substring(0, i + 1), resourcePath.substring(i + 1) + slash};
    }

    private void serveDownloadableResource(BaseFileServerServlet servlet, HttpServletResponse httpServletResponse, DownloadableResource resource) throws IOException {
        log.debug((Object)("Serving: " + resource));
        InputStream resourceStream = this.pluginManager.getPluginResourceAsStream(resource.getPluginKey(), resource.getLocation());
        if (resourceStream != null) {
            httpServletResponse.setContentType(resource.getContentType());
            servlet.serveFileImpl(httpServletResponse, resourceStream);
            try {
                resourceStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close input stream on resource:", (Throwable)e);
            }
        } else {
            log.info((Object)("Resource not found: " + resource));
        }
    }

    private String[] splitIntoLibraryAndResource(String requestUri, BaseFileServerServlet servlet) {
        requestUri = servlet.urlDecode(requestUri);
        int afterTheResourcesString = requestUri.indexOf("resources");
        requestUri = requestUri.substring(afterTheResourcesString + "resources".length() + 1);
        return requestUri.split("/", 2);
    }

    private static class DownloadableResource {
        private ResourceLocation resourceDescriptor;
        private String extraPath;
        private String pluginKey;
        private BaseFileServerServlet servlet;

        public DownloadableResource(BaseFileServerServlet servlet, String pluginKey, ResourceLocation resourceDescriptor, String extraPath) {
            if (extraPath != null && !"".equals(extraPath.trim()) && !resourceDescriptor.getLocation().endsWith("/")) {
                extraPath = "/" + extraPath;
            }
            this.resourceDescriptor = resourceDescriptor;
            this.extraPath = extraPath;
            this.pluginKey = pluginKey;
            this.servlet = servlet;
        }

        public String getContentType() {
            if (this.resourceDescriptor.getContentType() == null) {
                return this.servlet.getContentType(this.getLocation());
            }
            return this.resourceDescriptor.getContentType();
        }

        public String getLocation() {
            return this.resourceDescriptor.getLocation() + this.extraPath;
        }

        public String toString() {
            return "Resource: " + this.getLocation() + " (" + this.getContentType() + ")";
        }

        public String getPluginKey() {
            return this.pluginKey;
        }
    }
}

