/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders.classloading;

import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.JarClassLoader;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Scanner
implements FileFilter {
    private static Log log = LogFactory.getLog((Class)Scanner.class);
    File libDir;
    long lastModified;
    String pluginExtension = ".jar";
    Map deployedLoaders = new HashMap();

    public Scanner(File libDir) {
        this.libDir = libDir;
    }

    public boolean accept(File file) {
        return file.getName().endsWith(this.pluginExtension);
    }

    private void deploy(File file) throws MalformedURLException {
        if (this.isDeployed(file)) {
            return;
        }
        DeploymentUnit unit = new DeploymentUnit(file);
        JarClassLoader cl = new JarClassLoader(file, Thread.currentThread().getContextClassLoader());
        this.deployedLoaders.put(unit, cl);
    }

    public DeploymentUnit locateDeploymentUnit(File file) {
        Set dUnits = this.deployedLoaders.keySet();
        Iterator iterator = dUnits.iterator();
        while (iterator.hasNext()) {
            DeploymentUnit unit = (DeploymentUnit)iterator.next();
            if (!unit.path.getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return unit;
        }
        return null;
    }

    public boolean isDeployed(File file) {
        return this.locateDeploymentUnit(file) != null;
    }

    public void undeploy(File file) {
        DeploymentUnit unit = this.locateDeploymentUnit(file);
        if (unit != null) {
            JarClassLoader jcl = (JarClassLoader)this.deployedLoaders.remove(unit);
            jcl.close();
        }
    }

    public boolean isModified() {
        return this.libDir.canRead() && this.lastModified != this.libDir.lastModified();
    }

    public void scan() {
        Set dUnits = this.deployedLoaders.keySet();
        ArrayList<File> toUndeploy = new ArrayList<File>();
        Iterator iterator = dUnits.iterator();
        while (iterator.hasNext()) {
            DeploymentUnit unit = (DeploymentUnit)iterator.next();
            if (unit.path.exists() && unit.path.canRead()) continue;
            toUndeploy.add(unit.getPath());
        }
        this.undeploy(toUndeploy);
        File[] file = this.libDir.listFiles(this);
        if (file == null) {
            log.error((Object)("listFiles returned null for directory " + this.libDir.getAbsolutePath()));
        } else {
            for (int i = 0; i < file.length; ++i) {
                try {
                    if (this.isDeployed(file[i]) && this.isModified(file[i])) {
                        this.undeploy(file[i]);
                        this.deploy(file[i]);
                        continue;
                    }
                    if (this.isDeployed(file[i])) continue;
                    this.deploy(file[i]);
                    continue;
                }
                catch (MalformedURLException e) {
                    log.error((Object)("Error deploying plugin " + file[i].getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    private boolean isModified(File file) {
        DeploymentUnit unit = this.locateDeploymentUnit(file);
        return file.lastModified() > unit.lastModified();
    }

    private void undeploy(List toUndeploy) {
        Iterator iterator = toUndeploy.iterator();
        while (iterator.hasNext()) {
            this.undeploy((File)iterator.next());
        }
    }

    public Collection getDeploymentUnits() {
        return this.deployedLoaders.keySet();
    }

    public ClassLoader getClassLoader(DeploymentUnit deploymentUnit) {
        return (ClassLoader)this.deployedLoaders.get(deploymentUnit);
    }

    public void undeployAll() {
        Iterator iterator = this.deployedLoaders.values().iterator();
        while (iterator.hasNext()) {
            JarClassLoader jarClassLoader = (JarClassLoader)iterator.next();
            jarClassLoader.close();
            iterator.remove();
        }
    }
}

