/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.impl.StaticPlugin;
import com.atlassian.plugin.loaders.AbstractXmlPluginLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class SinglePluginLoader
extends AbstractXmlPluginLoader {
    List plugins;
    protected String resource;
    protected InputStream is;

    public SinglePluginLoader(String resource) {
        this.resource = resource;
    }

    public SinglePluginLoader(InputStream is) {
        this.is = is;
    }

    public Collection loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
            this.loadPlugins(moduleDescriptorFactory);
        }
        return this.plugins;
    }

    public boolean supportsRemoval() {
        return false;
    }

    public boolean supportsAddition() {
        return false;
    }

    public Collection removeMissingPlugins() {
        throw new UnsupportedOperationException("This PluginLoader does not support removal.");
    }

    public Collection addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        throw new UnsupportedOperationException("This PluginLoader does not support addition.");
    }

    public void removePlugin(Plugin plugin) throws PluginException {
        throw new PluginException("This PluginLoader does not support removal.");
    }

    private void loadPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        if (this.resource == null && this.is == null) {
            throw new PluginParseException("No resource or inputstream specified to load plugins from.");
        }
        try {
            Plugin plugin = this.configurePlugin(moduleDescriptorFactory, this.getDocument(), new StaticPlugin());
            this.plugins.add(plugin);
        }
        catch (DocumentException e) {
            throw new PluginParseException("Exception parsing plugin document", e);
        }
    }

    protected Document getDocument() throws DocumentException, PluginParseException {
        Document doc = null;
        doc = this.resource != null ? this.getDocument(this.resource) : this.getDocument(this.is);
        return doc;
    }

    public void setRecogniseSystemPlugins(boolean recogniseSystemPlugins) {
        this.recogniseSystemPlugins = recogniseSystemPlugins;
    }
}

