/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassPathPluginLoader
implements PluginLoader {
    private static Log log = LogFactory.getLog((Class)ClassPathPluginLoader.class);
    List plugins;
    String fileNameToLoad;

    public ClassPathPluginLoader() {
        this("atlassian-plugin.xml");
    }

    public ClassPathPluginLoader(String fileNameToLoad) {
        this.fileNameToLoad = fileNameToLoad;
    }

    private void loadClassPathPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Enumeration pluginDescriptorFiles;
        URL url = null;
        this.plugins = new ArrayList();
        try {
            pluginDescriptorFiles = ClassLoaderUtils.getResources(this.fileNameToLoad, this.getClass());
        }
        catch (IOException e) {
            log.error((Object)("Could not load classpath plugins: " + e), (Throwable)e);
            return;
        }
        while (pluginDescriptorFiles.hasMoreElements()) {
            url = (URL)pluginDescriptorFiles.nextElement();
            try {
                SinglePluginLoader loader = new SinglePluginLoader(url.openConnection().getInputStream());
                this.plugins.addAll(loader.loadAllPlugins(moduleDescriptorFactory));
            }
            catch (IOException e) {
                log.error((Object)("IOException parsing inputstream for : " + url), (Throwable)e);
            }
        }
    }

    public Collection loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        if (this.plugins == null) {
            this.loadClassPathPlugins(moduleDescriptorFactory);
        }
        return this.plugins;
    }

    public boolean supportsRemoval() {
        return false;
    }

    public boolean supportsAddition() {
        return false;
    }

    public Collection removeMissingPlugins() {
        throw new UnsupportedOperationException("This PluginLoader does not support removal.");
    }

    public Collection addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        throw new UnsupportedOperationException("This PluginLoader does not support addition.");
    }

    public void removePlugin(Plugin plugin) throws PluginException {
        throw new PluginException("This PluginLoader does not support removal.");
    }
}

