/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptorFactory;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AbstractXmlPluginLoader
implements PluginLoader {
    private static Log log = LogFactory.getLog((Class)AbstractXmlPluginLoader.class);
    protected boolean recogniseSystemPlugins = false;

    protected boolean isResource(Element element) {
        return "resource".equalsIgnoreCase(element.getName());
    }

    protected Document getDocument(String resource) throws DocumentException, PluginParseException {
        if (resource == null) {
            throw new PluginParseException("Couldn't find resource: " + resource);
        }
        InputStream is = ClassLoaderUtils.getResourceAsStream(resource, AbstractXmlPluginLoader.class);
        return this.getDocument(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getDocument(InputStream is) throws DocumentException, PluginParseException {
        if (is == null) {
            throw new PluginParseException("Invalid InputStream specified?");
        }
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(is);
            return document;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error((Object)("Bad inputstream close: " + e), (Throwable)e);
            }
        }
    }

    public abstract Collection loadAllPlugins(ModuleDescriptorFactory var1) throws PluginParseException;

    protected ModuleDescriptor createModuleDescriptor(Plugin plugin, Element element, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        String name = element.getName();
        ModuleDescriptor moduleDescriptorDescriptor = null;
        try {
            moduleDescriptorDescriptor = moduleDescriptorFactory.getModuleDescriptor(name);
        }
        catch (Exception e) {
            UnrecognisedModuleDescriptor descriptor = UnrecognisedModuleDescriptorFactory.createUnrecognisedModuleDescriptor(plugin, element, e, moduleDescriptorFactory);
            log.error((Object)("There were problems loading the module '" + name + "' in plugin '" + plugin.getName() + "'. The module has been disabled."));
            log.error((Object)descriptor.getErrorText(), (Throwable)e);
            return descriptor;
        }
        if (moduleDescriptorDescriptor == null) {
            log.info((Object)("The module '" + name + "' in plugin '" + plugin.getName() + "' is in the list of excluded module descriptors, so not enabling."));
            return null;
        }
        try {
            moduleDescriptorDescriptor.init(plugin, element);
        }
        catch (PluginParseException e) {
            UnloadableModuleDescriptor descriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, element, (Throwable)((Object)e), moduleDescriptorFactory);
            log.error((Object)("There were problems loading the module '" + name + "'. The module and its plugin have been disabled."));
            log.error((Object)descriptor.getErrorText(), (Throwable)((Object)e));
            return descriptor;
        }
        return moduleDescriptorDescriptor;
    }

    protected PluginInformation createPluginInformation(Element element) {
        PluginInformation pluginInfo = new PluginInformation();
        if (element.element("description") != null) {
            pluginInfo.setDescription(element.element("description").getTextTrim());
            if (element.element("description").attributeValue("key") != null) {
                pluginInfo.setDescriptionKey(element.element("description").attributeValue("key"));
            }
        }
        if (element.element("version") != null) {
            pluginInfo.setVersion(element.element("version").getTextTrim());
        }
        if (element.element("vendor") != null) {
            Element vendor = element.element("vendor");
            pluginInfo.setVendorName(vendor.attributeValue("name"));
            pluginInfo.setVendorUrl(vendor.attributeValue("url"));
        }
        Iterator iterator = element.elements("param").iterator();
        while (iterator.hasNext()) {
            Element param = (Element)iterator.next();
            if (param.attribute("name") == null) continue;
            pluginInfo.addParameter(param.attribute("name").getData().toString(), param.getText());
        }
        if (element.element("application-version") != null) {
            pluginInfo.setMaxVersion(Float.parseFloat(element.element("application-version").attributeValue("max")));
            pluginInfo.setMinVersion(Float.parseFloat(element.element("application-version").attributeValue("min")));
        }
        if (element.element("java-version") != null) {
            pluginInfo.setMinJavaVersion(Float.valueOf(element.element("java-version").attributeValue("min")));
        }
        return pluginInfo;
    }

    protected Plugin configurePlugin(ModuleDescriptorFactory moduleDescriptorFactory, Document doc, Plugin plugin) throws PluginParseException {
        Element root = doc.getRootElement();
        plugin.setName(root.attributeValue("name"));
        plugin.setKey(root.attributeValue("key"));
        if (root.attributeValue("i18n-name-key") != null) {
            plugin.setI18nNameKey(root.attributeValue("i18n-name-key"));
        }
        if (plugin.getKey().indexOf(":") > 0) {
            throw new PluginParseException("Plugin key's cannot contain ':'. Key is '" + plugin.getKey() + "'");
        }
        if ("disabled".equalsIgnoreCase(root.attributeValue("state"))) {
            plugin.setEnabledByDefault(false);
        }
        if (this.recogniseSystemPlugins && "true".equalsIgnoreCase(root.attributeValue("system"))) {
            plugin.setSystemPlugin(true);
        }
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            ModuleDescriptor moduleDescriptor;
            Element element = (Element)i.next();
            if ("plugin-info".equalsIgnoreCase(element.getName())) {
                plugin.setPluginInformation(this.createPluginInformation(element));
                continue;
            }
            if (this.isResource(element) || (moduleDescriptor = this.createModuleDescriptor(plugin, element, moduleDescriptorFactory)) == null) continue;
            if (plugin.getModuleDescriptor(moduleDescriptor.getKey()) != null) {
                throw new PluginParseException("Found duplicate key '" + moduleDescriptor.getKey() + "' within plugin '" + plugin.getKey() + "'");
            }
            plugin.addModuleDescriptor(moduleDescriptor);
            if (!(moduleDescriptor instanceof UnloadableModuleDescriptor)) continue;
            log.error((Object)("There were errors loading the plugin '" + plugin.getName() + "'. The plugin has been disabled."));
            return UnloadablePluginFactory.createUnloadablePlugin(plugin);
        }
        plugin.setResources(Resources.fromXml(root));
        return plugin;
    }
}

