/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.impl;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticPlugin
implements Plugin,
Comparable {
    private static final Log log = LogFactory.getLog((Class)StaticPlugin.class);
    private String name;
    private String i18nNameKey;
    private String key;
    private Map modules = new LinkedHashMap();
    private boolean enabledByDefault = true;
    private PluginInformation pluginInformation;
    List resourceDescriptors;
    private boolean enabled;
    private boolean system;
    private Resourced resources;
    private Date dateLoaded = new Date();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getI18nNameKey() {
        return this.i18nNameKey;
    }

    public void setI18nNameKey(String i18nNameKey) {
        this.i18nNameKey = i18nNameKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aPackage) {
        this.key = aPackage;
    }

    public void addModuleDescriptor(ModuleDescriptor moduleDescriptor) {
        this.modules.put(moduleDescriptor.getKey(), moduleDescriptor);
    }

    public Collection getModuleDescriptors() {
        return this.modules.values();
    }

    public ModuleDescriptor getModuleDescriptor(String key) {
        return (ModuleDescriptor)this.modules.get(key);
    }

    public List getModuleDescriptorsByModuleClass(Class aClass) {
        ArrayList<ModuleDescriptor> result = new ArrayList<ModuleDescriptor>();
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)iterator.next();
            Class moduleClass = moduleDescriptor.getModuleClass();
            if (!aClass.isAssignableFrom(moduleClass)) continue;
            result.add(moduleDescriptor);
        }
        return result;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault && this.pluginInformation.satisfiesMinJavaVersion();
    }

    public void setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
    }

    public PluginInformation getPluginInformation() {
        return this.pluginInformation;
    }

    public void setPluginInformation(PluginInformation pluginInformation) {
        this.pluginInformation = pluginInformation;
    }

    public void setResources(Resourced resources) {
        this.resources = resources;
    }

    public List getResourceDescriptors() {
        return this.resources.getResourceDescriptors();
    }

    public List getResourceDescriptors(String type) {
        return this.resources.getResourceDescriptors(type);
    }

    public ResourceLocation getResourceLocation(String type, String name) {
        return this.resources.getResourceLocation(type, name);
    }

    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.resources.getResourceDescriptor(type, name);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isUninstallable() {
        return false;
    }

    public Class loadClass(String clazz, Class callingClass) throws ClassNotFoundException {
        return ClassLoaderUtils.loadClass(clazz, callingClass);
    }

    public InputStream getResourceAsStream(String name) {
        return ClassLoaderUtils.getResourceAsStream(name, this.getClass());
    }

    public boolean isDynamicallyLoaded() {
        return false;
    }

    public boolean isSystemPlugin() {
        return this.system;
    }

    public boolean containsSystemModule() {
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)iterator.next();
            if (!moduleDescriptor.isSystemModule()) continue;
            return true;
        }
        return false;
    }

    public void setSystemPlugin(boolean system) {
        this.system = system;
    }

    public Date getDateLoaded() {
        return this.dateLoaded;
    }

    public int compareTo(Object o) {
        String validVersionPattern;
        if (!(o instanceof Plugin)) {
            return 1;
        }
        if (!((Plugin)o).getKey().equals(this.getKey())) {
            return 1;
        }
        String thisVersion = "0";
        if (StringUtils.isNotEmpty((String)this.getPluginInformation().getVersion())) {
            thisVersion = this.getPluginInformation().getVersion().replaceAll(" ", "");
        }
        String compareVersion = "0";
        if (StringUtils.isNotEmpty((String)((Plugin)o).getPluginInformation().getVersion())) {
            compareVersion = ((Plugin)o).getPluginInformation().getVersion().replaceAll(" ", "");
        }
        if (!thisVersion.matches(validVersionPattern = "[\\d\\.]*") || !compareVersion.matches(validVersionPattern)) {
            log.warn((Object)("Can't parse plugin version number. Taking the last loaded plugin ( v1 = " + thisVersion + ", v2 = " + compareVersion + ")."));
            return -1;
        }
        String[] v1 = thisVersion.split("\\.");
        String[] v2 = compareVersion.split("\\.");
        for (int i = 0; i < (v1.length > v2.length ? v1.length : v2.length); ++i) {
            if (Integer.parseInt(i >= v1.length ? "0" : v1[i]) < Integer.parseInt(i >= v2.length ? "0" : v2[i])) {
                return -1;
            }
            if (Integer.parseInt(i >= v1.length ? "0" : v1[i]) <= Integer.parseInt(i >= v2.length ? "0" : v2[i])) continue;
            return 1;
        }
        return 0;
    }

    public boolean isDeleteable() {
        return false;
    }
}

