/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors.servlet;

import com.atlassian.plugin.descriptors.servlet.ServletModuleDescriptor;
import com.atlassian.seraph.util.PathMapper;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class ServletModuleManager {
    PathMapper mapper = new PathMapper();
    Map descriptors = new HashMap();
    Map inittedServlets = new HashMap();

    public HttpServlet getServlet(String path, final ServletConfig servletConfig) throws ServletException {
        ServletModuleDescriptor descriptor;
        String completeKey = this.mapper.get(path);
        HttpServlet servlet = null;
        if (completeKey != null && (servlet = (HttpServlet)this.inittedServlets.get(completeKey)) == null && (descriptor = (ServletModuleDescriptor)this.descriptors.get(completeKey)) != null) {
            servlet = descriptor.getServlet();
            servlet.init(new ServletConfig(){

                public String getServletName() {
                    return descriptor.getName();
                }

                public ServletContext getServletContext() {
                    return servletConfig.getServletContext();
                }

                public String getInitParameter(String s) {
                    return (String)descriptor.getInitParams().get(s);
                }

                public Enumeration getInitParameterNames() {
                    return Collections.enumeration(descriptor.getInitParams().keySet());
                }
            });
            this.inittedServlets.put(completeKey, servlet);
        }
        return servlet;
    }

    public void addModule(ServletModuleDescriptor descriptor) {
        this.descriptors.put(descriptor.getCompleteKey(), descriptor);
        Iterator iterator = descriptor.getPaths().iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            this.mapper.put(descriptor.getCompleteKey(), path);
        }
    }

    public void removeModule(ServletModuleDescriptor descriptor) {
        this.descriptors.remove(descriptor.getCompleteKey());
        this.inittedServlets.remove(descriptor.getCompleteKey());
        Iterator iterator = descriptor.getPaths().iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            this.mapper.put(path, null);
        }
    }
}

