/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginManager;
import com.atlassian.plugin.PluginManagerState;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginStateStore;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.loaders.PluginLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultPluginManager
implements PluginManager {
    private static final Log log = LogFactory.getLog((Class)DefaultPluginManager.class);
    private final List pluginLoaders;
    private final PluginStateStore store;
    private ModuleDescriptorFactory moduleDescriptorFactory;
    private PluginManagerState currentState;
    private HashMap plugins;
    private HashMap pluginToPluginLoader;

    public DefaultPluginManager(PluginStateStore store, List pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory) {
        this.pluginLoaders = pluginLoaders;
        this.store = store;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.currentState = store.loadPluginState();
    }

    public void init() throws PluginParseException {
        this.plugins = new HashMap();
        this.pluginToPluginLoader = new HashMap();
        Iterator iterator = this.pluginLoaders.iterator();
        while (iterator.hasNext()) {
            PluginLoader loader = (PluginLoader)iterator.next();
            Iterator iterator1 = loader.loadAllPlugins(this.moduleDescriptorFactory).iterator();
            while (iterator1.hasNext()) {
                this.addPlugin(loader, (Plugin)iterator1.next());
            }
        }
    }

    public int scanForNewPlugins() throws PluginParseException {
        int numberFound = 0;
        Iterator iterator = this.pluginLoaders.iterator();
        while (iterator.hasNext()) {
            PluginLoader loader = (PluginLoader)iterator.next();
            if (!loader.supportsAddition()) continue;
            Collection addedPlugins = loader.addFoundPlugins(this.moduleDescriptorFactory);
            Iterator iterator1 = addedPlugins.iterator();
            while (iterator1.hasNext()) {
                Plugin newPlugin = (Plugin)iterator1.next();
                ++numberFound;
                this.addPlugin(loader, newPlugin);
            }
        }
        return numberFound;
    }

    public void uninstall(Plugin plugin) throws PluginException {
        PluginLoader loader;
        if (!plugin.isUninstallable()) {
            throw new PluginException("Plugin is not uninstallable: " + plugin.getKey());
        }
        if (this.isPluginEnabled(plugin.getKey())) {
            this.disablePlugin(plugin.getKey());
        }
        if ((loader = (PluginLoader)this.pluginToPluginLoader.remove(plugin)) == null || !loader.supportsRemoval()) {
            throw new PluginException("Not uninstalling plugin - could not find plugin loader, or loader doesn't allow removal. Plugin: " + plugin.getKey());
        }
        this.plugins.remove(plugin.getKey());
        Iterator it = plugin.getModuleDescriptors().iterator();
        while (it.hasNext()) {
            ModuleDescriptor descriptor = (ModuleDescriptor)it.next();
            if (descriptor instanceof StateAware && this.isPluginModuleEnabled(descriptor.getCompleteKey())) {
                ((StateAware)((Object)descriptor)).disabled();
            }
            descriptor.destroy(plugin);
        }
        this.currentState.removeState(plugin.getKey());
        this.saveState();
        if (plugin.isDeleteable()) {
            loader.removePlugin(plugin);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void addPlugin(PluginLoader loader, Plugin plugin) throws PluginParseException {
        if (this.plugins.containsKey(plugin.getKey())) {
            match = (Plugin)this.plugins.get(plugin.getKey());
            if (plugin.compareTo(match) > 0) {
                if (DefaultPluginManager.log.isDebugEnabled()) {
                    DefaultPluginManager.log.debug((Object)("We found a newer '" + plugin.getKey() + "'"));
                }
                try {
                    this.uninstall(match);
                    if (!DefaultPluginManager.log.isDebugEnabled()) ** GOTO lbl15
                    DefaultPluginManager.log.debug((Object)("Older '" + plugin.getKey() + "' uninstalled."));
                }
                catch (PluginException e) {
                    throw new PluginParseException("Duplicate plugin found (installed version is older) and could not be removed: '" + plugin.getKey() + "'");
                }
            } else if (DefaultPluginManager.log.isDebugEnabled()) {
                DefaultPluginManager.log.debug((Object)("Duplicate plugin found (installed version is the same or newer): '" + plugin.getKey() + "'"));
            }
        }
lbl15:
        // 7 sources

        this.plugins.put(plugin.getKey(), plugin);
        moduleDescriptors = new ArrayList<E>(plugin.getModuleDescriptors());
        it = moduleDescriptors.iterator();
        while (it.hasNext()) {
            descriptor = (ModuleDescriptor)it.next();
            if (!(descriptor instanceof StateAware)) {
                if (!DefaultPluginManager.log.isDebugEnabled()) continue;
                DefaultPluginManager.log.debug((Object)("ModuleDescriptor '" + descriptor.getName() + "' is not StateAware. No need to enable."));
                continue;
            }
            if (!this.isPluginModuleEnabled(descriptor.getCompleteKey())) {
                if (!DefaultPluginManager.log.isDebugEnabled()) continue;
                DefaultPluginManager.log.debug((Object)("Plugin is not enabled, so not enabling ModuleDescriptor '" + descriptor.getName() + "'."));
                continue;
            }
            try {
                ((StateAware)descriptor).enabled();
            }
            catch (Throwable t) {
                DefaultPluginManager.log.error((Object)("There was an error loading the descriptor '" + descriptor.getName() + "' of plugin '" + plugin.getKey() + "'. Disabling."), t);
                unloadableDescriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, descriptor, t);
                unloadablePlugin = UnloadablePluginFactory.createUnloadablePlugin(plugin, unloadableDescriptor);
                this.replacePluginWithUnloadablePlugin(plugin, unloadablePlugin);
                plugin = unloadablePlugin;
            }
        }
        this.pluginToPluginLoader.put(plugin, loader);
    }

    private void saveState() {
        this.store.savePluginState(this.currentState);
    }

    public Collection getPlugins() {
        return this.plugins.values();
    }

    public Collection getEnabledPlugins() {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        Iterator iterator = this.plugins.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Plugin p = this.getEnabledPlugin(key);
            if (p == null) continue;
            result.add(p);
        }
        return result;
    }

    public Plugin getPlugin(String key) {
        return (Plugin)this.plugins.get(key);
    }

    public Plugin getEnabledPlugin(String pluginKey) {
        if (!this.isPluginEnabled(pluginKey)) {
            return null;
        }
        return this.getPlugin(pluginKey);
    }

    public ModuleDescriptor getPluginModule(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        Plugin plugin = this.getPlugin(key.getPluginKey());
        if (plugin == null) {
            return null;
        }
        return plugin.getModuleDescriptor(key.getModuleKey());
    }

    public ModuleDescriptor getEnabledPluginModule(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        if (!this.isPluginModuleEnabled(completeKey)) {
            return null;
        }
        return this.getEnabledPlugin(key.getPluginKey()).getModuleDescriptor(key.getModuleKey());
    }

    public List getEnabledModulesByClass(Class moduleClass) {
        LinkedList<Object> result = new LinkedList<Object>();
        Iterator iterator = this.plugins.values().iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            if (!this.isPluginEnabled(plugin.getKey())) continue;
            Iterator iterator1 = plugin.getModuleDescriptors().iterator();
            while (iterator1.hasNext()) {
                Class moduleDescClass;
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)iterator1.next();
                if (!this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey()) || (moduleDescClass = moduleDescriptor.getModuleClass()) == null || !moduleClass.isAssignableFrom(moduleDescClass)) continue;
                try {
                    Object module = moduleDescriptor.getModule();
                    if (module == null) continue;
                    result.add(module);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        return result;
    }

    public void enablePlugin(String key) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a plugin key to disable.");
        }
        if (!this.plugins.containsKey(key)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No plugin was found for key '" + key + "'. Not enabling."));
            }
            return;
        }
        Plugin plugin = (Plugin)this.plugins.get(key);
        if (!plugin.getPluginInformation().satisfiesMinJavaVersion()) {
            log.error((Object)("Minimum Java version of '" + plugin.getPluginInformation().getMinJavaVersion() + "' was not satisfied for module '" + key + "'. Not enabling."));
            return;
        }
        if (!plugin.isEnabledByDefault()) {
            this.currentState.setState(key, Boolean.TRUE);
        } else {
            this.currentState.removeState(key);
        }
        ArrayList moduleDescriptors = new ArrayList(plugin.getModuleDescriptors());
        Iterator it = moduleDescriptors.iterator();
        while (it.hasNext()) {
            ModuleDescriptor descriptor = (ModuleDescriptor)it.next();
            if (!(descriptor instanceof StateAware)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("ModuleDescriptor '" + descriptor.getName() + "' is not StateAware. No need to enable."));
                continue;
            }
            if (!this.isPluginModuleEnabled(descriptor.getCompleteKey())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Plugin is not enabled, so not enabling ModuleDescriptor '" + descriptor.getName() + "'."));
                continue;
            }
            try {
                ((StateAware)((Object)descriptor)).enabled();
            }
            catch (Exception t) {
                log.error((Object)("There was an error loading the descriptor '" + descriptor.getName() + "' of plugin '" + plugin.getKey() + "'. Disabling."), (Throwable)t);
                UnloadableModuleDescriptor unloadableDescriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, descriptor, t);
                UnloadablePlugin unloadablePlugin = UnloadablePluginFactory.createUnloadablePlugin(plugin, unloadableDescriptor);
                this.replacePluginWithUnloadablePlugin(plugin, unloadablePlugin);
            }
        }
        this.saveState();
    }

    public void disablePlugin(String key) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a plugin key to disable.");
        }
        if (!this.plugins.containsKey(key)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No plugin was found for key '" + key + "'. Not disabling."));
            }
            return;
        }
        Plugin plugin = (Plugin)this.plugins.get(key);
        ArrayList moduleDescriptors = new ArrayList(plugin.getModuleDescriptors());
        Collections.reverse(moduleDescriptors);
        Iterator it = moduleDescriptors.iterator();
        while (it.hasNext()) {
            ModuleDescriptor descriptor = (ModuleDescriptor)it.next();
            if (!(descriptor instanceof StateAware)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("ModuleDescriptor '" + descriptor.getName() + "' is not StateAware. No need to disable."));
                continue;
            }
            if (!this.isPluginModuleEnabled(descriptor.getCompleteKey())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Plugin is not enabled, so not disabling ModuleDescriptor '" + descriptor.getName() + "'."));
                continue;
            }
            ((StateAware)((Object)descriptor)).disabled();
        }
        if (plugin.isEnabledByDefault()) {
            this.currentState.setState(key, Boolean.FALSE);
        } else {
            this.currentState.removeState(key);
        }
        this.saveState();
    }

    public void disablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Returned module for key '" + completeKey + "' was null. Not disabling."));
            }
            return;
        }
        if (module.isEnabledByDefault()) {
            this.currentState.setState(completeKey, Boolean.FALSE);
        } else {
            this.currentState.removeState(completeKey);
        }
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).disabled();
        }
        this.saveState();
    }

    public void enablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Returned module for key '" + completeKey + "' was null. Not enabling."));
            }
            return;
        }
        if (!module.satisfiesMinJavaVersion()) {
            log.error((Object)("Minimum Java version of '" + module.getMinJavaVersion() + "' was not satisfied for module '" + completeKey + "'. Not enabling."));
            return;
        }
        if (!module.isEnabledByDefault()) {
            this.currentState.setState(completeKey, Boolean.TRUE);
        } else {
            this.currentState.removeState(completeKey);
        }
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).enabled();
        }
        this.saveState();
    }

    public boolean isPluginModuleEnabled(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        ModuleDescriptor pluginModule = this.getPluginModule(completeKey);
        return this.isPluginEnabled(key.getPluginKey()) && pluginModule != null && this.currentState.isEnabled(pluginModule);
    }

    public boolean isPluginEnabled(String key) {
        return this.plugins.containsKey(key) && this.currentState.isEnabled((Plugin)this.plugins.get(key));
    }

    public List getEnabledModuleDescriptorsByClass(Class descriptorClazz) {
        LinkedList<ModuleDescriptor> result = new LinkedList<ModuleDescriptor>();
        Iterator iterator = this.plugins.values().iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            if (!this.isPluginEnabled(plugin.getKey())) continue;
            Iterator iterator1 = plugin.getModuleDescriptors().iterator();
            while (iterator1.hasNext()) {
                ModuleDescriptor module = (ModuleDescriptor)iterator1.next();
                if (!descriptorClazz.isInstance(module) || !this.isPluginModuleEnabled(module.getCompleteKey())) continue;
                result.add(module);
            }
        }
        return result;
    }

    public List getEnabledModuleDescriptorsByType(String type) throws PluginParseException, IllegalArgumentException {
        Class descriptorClazz = this.moduleDescriptorFactory.getModuleDescriptorClass(type);
        if (descriptorClazz == null) {
            throw new IllegalArgumentException("No module descriptor of type: " + type + " found.");
        }
        return this.getEnabledModuleDescriptorsByClass(descriptorClazz);
    }

    public InputStream getDynamicResourceAsStream(String name) {
        Iterator iterator = this.plugins.values().iterator();
        while (iterator.hasNext()) {
            InputStream is;
            Plugin plugin = (Plugin)iterator.next();
            if (!plugin.isDynamicallyLoaded() || !this.isPluginEnabled(plugin.getKey()) || (is = plugin.getResourceAsStream(name)) == null) continue;
            return is;
        }
        return null;
    }

    public InputStream getPluginResourceAsStream(String pluginKey, String resourcePath) {
        Plugin plugin = this.getEnabledPlugin(pluginKey);
        if (plugin == null) {
            log.error((Object)("Attempted to retreive resource " + resourcePath + " for non-existent or inactive plugin " + pluginKey));
            return null;
        }
        return plugin.getResourceAsStream(resourcePath);
    }

    protected void replacePluginWithUnloadablePlugin(Plugin plugin, UnloadablePlugin unloadablePlugin) {
        unloadablePlugin.setUninstallable(plugin.isUninstallable());
        this.plugins.put(plugin.getKey(), unloadablePlugin);
        this.currentState.setState(plugin.getKey(), Boolean.FALSE);
    }

    public boolean isSystemPlugin(String key) {
        Plugin plugin = this.getPlugin(key);
        return plugin != null && plugin.isSystemPlugin();
    }
}

