/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.util;

import com.atlassian.seraph.config.SecurityConfigFactory;
import com.opensymphony.user.User;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;

public class GroupCache {
    public static final String GROUP_CACHE_KEY = "atlassian.core.util.groups.cache.key";

    public static Collection getGroups(HttpServletRequest request) {
        if (request == null) {
            return Collections.EMPTY_LIST;
        }
        Collection groups = (Collection)request.getAttribute(GROUP_CACHE_KEY);
        if (groups != null) {
            return groups;
        }
        User remoteUser = (User)SecurityConfigFactory.getInstance().getAuthenticator().getUser(request);
        if (remoteUser == null) {
            return Collections.EMPTY_LIST;
        }
        groups = remoteUser.getGroups();
        request.setAttribute(GROUP_CACHE_KEY, (Object)groups);
        return groups;
    }
}

